/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting.craftingmonitor;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.refinedmods.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.refinedmods.refinedstorage.api.render.IElementDrawers;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.render.Styles;
import com.refinedmods.refinedstorage.util.PacketBufferUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ErrorCraftingMonitorElement
implements ICraftingMonitorElement {
    public static final ResourceLocation ID = new ResourceLocation("error");
    private final ICraftingMonitorElement base;
    private final String message;

    public ErrorCraftingMonitorElement(ICraftingMonitorElement base, String message) {
        this.base = base;
        this.message = message;
    }

    @Override
    public void draw(MatrixStack matrixStack, int x, int y, IElementDrawers drawers) {
        this.base.draw(matrixStack, x, y, drawers);
        drawers.getErrorDrawer().draw(matrixStack, x, y, null);
    }

    @Override
    @Nullable
    public List<ITextComponent> getTooltip() {
        ArrayList<ITextComponent> items = new ArrayList<ITextComponent>(this.base.getTooltip());
        items.add((ITextComponent)new TranslationTextComponent(this.message).func_230530_a_(Styles.RED));
        return items;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public ResourceLocation getBaseId() {
        return this.base.getId();
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.func_192572_a(this.base.getId());
        buf.func_180714_a(this.message);
        this.base.write(buf);
    }

    public static ErrorCraftingMonitorElement read(PacketBuffer buf) {
        ResourceLocation id = buf.func_192575_l();
        String message = PacketBufferUtils.readString(buf);
        return new ErrorCraftingMonitorElement(API.instance().getCraftingMonitorElementRegistry().get(id).apply(buf), message);
    }

    @Override
    public boolean merge(ICraftingMonitorElement element) {
        return this.elementHashCode() == element.elementHashCode() && this.base.merge(((ErrorCraftingMonitorElement)element).base);
    }

    @Override
    public int baseElementHashCode() {
        return this.base.elementHashCode();
    }

    @Override
    public int elementHashCode() {
        return this.base.elementHashCode() ^ this.message.hashCode();
    }

    public void mergeBases(ICraftingMonitorElement element) {
        this.base.merge(element);
    }
}

