/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.INetworkNodeVisitor;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.ConnectivityStateChangeCause;
import com.refinedmods.refinedstorage.block.BaseBlock;
import com.refinedmods.refinedstorage.block.NetworkNodeBlock;
import com.refinedmods.refinedstorage.tile.config.RedstoneMode;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;

public abstract class NetworkNode
implements INetworkNode,
INetworkNodeVisitor {
    private static final String NBT_OWNER = "Owner";
    private static final String NBT_VERSION = "Version";
    private static final int CURRENT_VERSION = 1;
    @Nullable
    protected INetwork network;
    protected World world;
    protected BlockPos pos;
    protected int ticks;
    protected RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    private boolean redstonePowered = false;
    @Nullable
    protected UUID owner;
    protected String version;
    private Direction direction;
    private boolean throttlingDisabled = true;
    private boolean couldUpdate;
    private int ticksSinceUpdateChanged;

    protected NetworkNode(World world, BlockPos pos) {
        if (world == null) {
            throw new IllegalArgumentException("World cannot be null");
        }
        this.world = world;
        this.pos = pos;
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode redstoneMode) {
        this.redstoneMode = redstoneMode;
        this.markDirty();
    }

    @Override
    @Nonnull
    public ItemStack getItemStack() {
        return new ItemStack((IItemProvider)Item.field_179220_a.get(this.world.func_180495_p(this.pos).func_177230_c()), 1);
    }

    @Override
    public void onConnected(INetwork network) {
        this.onConnectedStateChange(network, true, ConnectivityStateChangeCause.GRAPH_CHANGE);
        this.network = network;
    }

    @Override
    public void onDisconnected(INetwork network) {
        this.network = null;
        this.onConnectedStateChange(network, false, ConnectivityStateChangeCause.GRAPH_CHANGE);
    }

    protected void onConnectedStateChange(INetwork network, boolean state, ConnectivityStateChangeCause cause) {
    }

    @Override
    public void markDirty() {
        if (!this.world.field_72995_K) {
            API.instance().getNetworkNodeManager((ServerWorld)this.world).markForSaving();
        }
    }

    @Override
    public boolean isActive() {
        return this.redstoneMode.isEnabled(this.redstonePowered);
    }

    protected final boolean canUpdate() {
        if (this.isActive() && this.network != null) {
            return this.network.canRun();
        }
        return false;
    }

    protected int getUpdateThrottleInactiveToActive() {
        return 20;
    }

    protected int getUpdateThrottleActiveToInactive() {
        return 4;
    }

    public void setRedstonePowered(boolean redstonePowered) {
        this.redstonePowered = redstonePowered;
    }

    @Override
    public void update() {
        if (this.ticks == 0) {
            this.redstonePowered = this.world.func_175640_z(this.pos);
        }
        ++this.ticks;
        boolean canUpdate = this.canUpdate();
        if (this.couldUpdate != canUpdate) {
            ++this.ticksSinceUpdateChanged;
            if ((!canUpdate ? this.ticksSinceUpdateChanged > this.getUpdateThrottleActiveToInactive() : this.ticksSinceUpdateChanged > this.getUpdateThrottleInactiveToActive()) || this.throttlingDisabled) {
                this.ticksSinceUpdateChanged = 0;
                this.couldUpdate = canUpdate;
                this.throttlingDisabled = false;
                BlockState blockState = this.world.func_180495_p(this.pos);
                if (blockState.func_177230_c() instanceof NetworkNodeBlock && ((NetworkNodeBlock)blockState.func_177230_c()).hasConnectedState()) {
                    this.world.func_175656_a(this.pos, (BlockState)this.world.func_180495_p(this.pos).func_206870_a((Property)NetworkNodeBlock.CONNECTED, (Comparable)Boolean.valueOf(canUpdate)));
                }
                if (this.network != null) {
                    this.onConnectedStateChange(this.network, canUpdate, ConnectivityStateChangeCause.REDSTONE_MODE_OR_NETWORK_ENERGY_CHANGE);
                    if (this.shouldRebuildGraphOnChange()) {
                        this.network.getNodeGraph().invalidate(Action.PERFORM, this.network.getWorld(), this.network.getPosition());
                    }
                }
            }
        } else {
            this.ticksSinceUpdateChanged = 0;
        }
    }

    @Override
    public CompoundNBT write(CompoundNBT tag) {
        if (this.owner != null) {
            tag.func_186854_a(NBT_OWNER, this.owner);
        }
        tag.func_74768_a(NBT_VERSION, 1);
        this.writeConfiguration(tag);
        return tag;
    }

    public CompoundNBT writeConfiguration(CompoundNBT tag) {
        this.redstoneMode.write(tag);
        return tag;
    }

    public void read(CompoundNBT tag) {
        if (tag.func_186855_b(NBT_OWNER)) {
            this.owner = tag.func_186857_a(NBT_OWNER);
        }
        if (tag.func_74764_b(NBT_VERSION)) {
            this.version = tag.func_74779_i(NBT_VERSION);
        }
        this.readConfiguration(tag);
    }

    public void readConfiguration(CompoundNBT tag) {
        this.redstoneMode = RedstoneMode.read(tag);
    }

    @Override
    @Nullable
    public INetwork getNetwork() {
        return this.network;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    protected boolean canConduct(Direction direction) {
        return true;
    }

    @Override
    public void visit(INetworkNodeVisitor.Operator operator) {
        for (Direction facing : Direction.values()) {
            if (!this.canConduct(facing)) continue;
            operator.apply(this.world, this.pos.func_177972_a(facing), facing.func_176734_d());
        }
    }

    @Nullable
    public TileEntity getFacingTile() {
        return this.world.func_175625_s(this.pos.func_177972_a(this.getDirection()));
    }

    public Direction getDirection() {
        BlockState state;
        if (this.direction == null && (state = this.world.func_180495_p(this.pos)).func_177230_c() instanceof BaseBlock) {
            this.direction = (Direction)state.func_177229_b((Property)((BaseBlock)state.func_177230_c()).getDirection().getProperty());
        }
        return this.direction;
    }

    public void onDirectionChanged(Direction direction) {
        this.direction = direction;
    }

    @Nullable
    public IItemHandler getDrops() {
        return null;
    }

    public boolean shouldRebuildGraphOnChange() {
        return false;
    }

    @Override
    public void setOwner(@Nullable UUID owner) {
        this.owner = owner;
        this.markDirty();
    }

    @Override
    @Nullable
    public UUID getOwner() {
        return this.owner;
    }
}

