/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.block;

import com.refinedmods.refinedstorage.block.BlockDirection;
import com.refinedmods.refinedstorage.block.NetworkNodeBlock;
import com.refinedmods.refinedstorage.block.shape.ShapeCache;
import com.refinedmods.refinedstorage.capability.NetworkNodeProxyCapability;
import com.refinedmods.refinedstorage.tile.CableTile;
import com.refinedmods.refinedstorage.util.BlockUtils;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class CableBlock
extends NetworkNodeBlock
implements IWaterLoggable {
    private static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    private static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    private static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    private static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    private static final BooleanProperty UP = BooleanProperty.func_177716_a((String)"up");
    private static final BooleanProperty DOWN = BooleanProperty.func_177716_a((String)"down");
    private static final BooleanProperty WATERLOGGED = BooleanProperty.func_177716_a((String)"waterlogged");
    protected static final VoxelShape HOLDER_NORTH = CableBlock.func_208617_a((double)7.0, (double)7.0, (double)2.0, (double)9.0, (double)9.0, (double)6.0);
    protected static final VoxelShape HOLDER_EAST = CableBlock.func_208617_a((double)10.0, (double)7.0, (double)7.0, (double)14.0, (double)9.0, (double)9.0);
    protected static final VoxelShape HOLDER_SOUTH = CableBlock.func_208617_a((double)7.0, (double)7.0, (double)10.0, (double)9.0, (double)9.0, (double)14.0);
    protected static final VoxelShape HOLDER_WEST = CableBlock.func_208617_a((double)2.0, (double)7.0, (double)7.0, (double)6.0, (double)9.0, (double)9.0);
    protected static final VoxelShape HOLDER_UP = CableBlock.func_208617_a((double)7.0, (double)10.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0);
    protected static final VoxelShape HOLDER_DOWN = CableBlock.func_208617_a((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)6.0, (double)9.0);
    private static final VoxelShape SHAPE_CORE = CableBlock.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape SHAPE_NORTH = CableBlock.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0);
    private static final VoxelShape SHAPE_EAST = CableBlock.func_208617_a((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape SHAPE_SOUTH = CableBlock.func_208617_a((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = CableBlock.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0);
    private static final VoxelShape SHAPE_UP = CableBlock.func_208617_a((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_DOWN = CableBlock.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);

    public CableBlock(AbstractBlock.Properties props) {
        super(props);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public CableBlock() {
        super(BlockUtils.DEFAULT_GLASS_PROPERTIES);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState func_196271_a(BlockState state, Direction dir, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        return this.getState(state, world, pos);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return ShapeCache.getOrCreate(state, CableBlock::getCableShape);
    }

    protected static VoxelShape getCableShape(BlockState state) {
        VoxelShape shape = SHAPE_CORE;
        if (Boolean.TRUE.equals(state.func_177229_b((Property)NORTH))) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_NORTH);
        }
        if (Boolean.TRUE.equals(state.func_177229_b((Property)EAST))) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_EAST);
        }
        if (Boolean.TRUE.equals(state.func_177229_b((Property)SOUTH))) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_SOUTH);
        }
        if (Boolean.TRUE.equals(state.func_177229_b((Property)WEST))) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_WEST);
        }
        if (Boolean.TRUE.equals(state.func_177229_b((Property)UP))) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_UP);
        }
        if (Boolean.TRUE.equals(state.func_177229_b((Property)DOWN))) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)SHAPE_DOWN);
        }
        return shape;
    }

    @Override
    protected void onDirectionChanged(World world, BlockPos pos, Direction newDirection) {
        world.func_175656_a(pos, this.getState(world.func_180495_p(pos), (IWorld)world, pos));
        super.onDirectionChanged(world, pos, newDirection);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getState(this.func_176223_P(), (IWorld)ctx.func_195991_k(), ctx.func_195995_a());
    }

    public FluidState func_204507_t(BlockState state) {
        return Boolean.TRUE.equals(state.func_177229_b((Property)WATERLOGGED)) ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return super.func_204509_a(worldIn, pos, state, fluidStateIn);
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return super.func_204510_a(worldIn, pos, state, fluidIn);
    }

    private boolean hasNode(IWorld world, BlockPos pos, BlockState state, Direction direction) {
        if (this.getDirection() != BlockDirection.NONE && ((Direction)state.func_177229_b((Property)this.getDirection().getProperty())).func_176734_d() == direction) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null) {
            return false;
        }
        return tile.getCapability(NetworkNodeProxyCapability.NETWORK_NODE_PROXY_CAPABILITY, direction).isPresent();
    }

    private BlockState getState(BlockState currentState, IWorld world, BlockPos pos) {
        boolean north = this.hasNode(world, pos.func_177972_a(Direction.NORTH), currentState, Direction.SOUTH);
        boolean east = this.hasNode(world, pos.func_177972_a(Direction.EAST), currentState, Direction.WEST);
        boolean south = this.hasNode(world, pos.func_177972_a(Direction.SOUTH), currentState, Direction.NORTH);
        boolean west = this.hasNode(world, pos.func_177972_a(Direction.WEST), currentState, Direction.EAST);
        boolean up = this.hasNode(world, pos.func_177972_a(Direction.UP), currentState, Direction.DOWN);
        boolean down = this.hasNode(world, pos.func_177972_a(Direction.DOWN), currentState, Direction.UP);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)currentState.func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(north))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(east))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(south))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(west))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(up))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(down));
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CableTile();
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, WATERLOGGED});
    }
}

