/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.integration.jei;

import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.integration.jei.Ingredient;
import com.refinedmods.refinedstorage.screen.grid.stack.IGridStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import net.minecraft.item.ItemStack;

public class IngredientTracker {
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();

    public IngredientTracker(IRecipeLayout recipeLayout) {
        for (IGuiIngredient guiIngredient : recipeLayout.getItemStacks().getGuiIngredients().values()) {
            if (!guiIngredient.isInput() || guiIngredient.getAllIngredients().isEmpty()) continue;
            this.ingredients.add(new Ingredient((IGuiIngredient<ItemStack>)guiIngredient));
        }
    }

    public Collection<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public void addAvailableStack(ItemStack stack, @Nullable IGridStack gridStack) {
        int available = stack.func_190916_E();
        for (Ingredient ingredient : this.ingredients) {
            if (available == 0) {
                return;
            }
            Optional<ItemStack> match = ingredient.getGuiIngredient().getAllIngredients().stream().filter(s -> API.instance().getComparer().isEqual(stack, (ItemStack)s, 1)).findFirst();
            if (!match.isPresent()) continue;
            if (gridStack != null && gridStack.isCraftable()) {
                ingredient.setCraftStackId(gridStack.getId());
                continue;
            }
            if (ingredient.isAvailable()) continue;
            int needed = ingredient.getMissingAmount();
            int used = Math.min(available, needed);
            ingredient.fulfill(used);
            available -= used;
        }
    }

    public boolean hasMissing() {
        return this.ingredients.stream().anyMatch(ingredient -> !ingredient.isAvailable());
    }

    public boolean hasMissingButAutocraftingAvailable() {
        return this.ingredients.stream().anyMatch(ingredient -> !ingredient.isAvailable() && ingredient.isCraftable());
    }

    public boolean isAutocraftingAvailable() {
        return this.ingredients.stream().anyMatch(Ingredient::isCraftable);
    }

    public Map<UUID, Integer> createCraftingRequests() {
        HashMap<UUID, Integer> toRequest = new HashMap<UUID, Integer>();
        for (Ingredient ingredient : this.ingredients) {
            if (ingredient.isAvailable() || !ingredient.isCraftable()) continue;
            toRequest.merge(ingredient.getCraftStackId(), ingredient.getMissingAmount(), Integer::sum);
        }
        return toRequest;
    }
}

