/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen.grid.filtering;

import com.refinedmods.refinedstorage.screen.grid.stack.IGridStack;
import java.util.function.Predicate;

public class ModGridFilter
implements Predicate<IGridStack> {
    private final String inputModName;

    public ModGridFilter(String inputModName) {
        this.inputModName = this.standardify(inputModName);
    }

    @Override
    public boolean test(IGridStack stack) {
        String modId = stack.getModId();
        if (modId != null) {
            if (modId.contains(this.inputModName)) {
                return true;
            }
            String modName = stack.getModName();
            if (modName != null && (modName = this.standardify(modName)).contains(this.inputModName)) {
                return true;
            }
        }
        return false;
    }

    private String standardify(String input) {
        return input.toLowerCase().replace(" ", "");
    }
}

