/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen.grid.view;

import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.screen.grid.GridScreen;
import com.refinedmods.refinedstorage.screen.grid.filtering.GridFilterParser;
import com.refinedmods.refinedstorage.screen.grid.sorting.IGridSorter;
import com.refinedmods.refinedstorage.screen.grid.sorting.SortingDirection;
import com.refinedmods.refinedstorage.screen.grid.stack.IGridStack;
import com.refinedmods.refinedstorage.screen.grid.view.IGridView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class GridViewImpl
implements IGridView {
    private final GridScreen screen;
    private boolean canCraft;
    private boolean active = false;
    private final IGridSorter defaultSorter;
    private final List<IGridSorter> sorters;
    private List<IGridStack> stacks = new ArrayList<IGridStack>();
    protected final Map<UUID, IGridStack> map = new HashMap<UUID, IGridStack>();

    public GridViewImpl(GridScreen screen, IGridSorter defaultSorter, List<IGridSorter> sorters) {
        this.screen = screen;
        this.defaultSorter = defaultSorter;
        this.sorters = sorters;
    }

    @Override
    public List<IGridStack> getStacks() {
        return this.stacks;
    }

    @Override
    public Collection<IGridStack> getAllStacks() {
        return this.map.values();
    }

    @Override
    @Nullable
    public IGridStack get(UUID id) {
        return this.map.get(id);
    }

    @Override
    public void sort() {
        if (!this.screen.canSort()) {
            return;
        }
        if (this.screen.getGrid().isGridActive()) {
            this.stacks = this.map.values().stream().filter(this.getActiveFilters()).sorted(this.getActiveSort()).collect(Collectors.toCollection(ArrayList::new));
            this.active = true;
        } else {
            this.stacks = new ArrayList<IGridStack>();
            this.active = false;
        }
        this.screen.updateScrollbar();
    }

    private Comparator<IGridStack> getActiveSort() {
        IGrid grid = this.screen.getGrid();
        SortingDirection sortingDirection = grid.getSortingDirection() == 1 ? SortingDirection.DESCENDING : SortingDirection.ASCENDING;
        return Stream.concat(Stream.of(this.defaultSorter), this.sorters.stream().filter(s -> s.isApplicable(grid))).map(sorter -> (o1, o2) -> sorter.compare((IGridStack)o1, (IGridStack)o2, sortingDirection)).reduce((l, r) -> r.thenComparing(l)).orElseThrow(IllegalStateException::new);
    }

    private Predicate<IGridStack> getActiveFilters() {
        IGrid grid = this.screen.getGrid();
        Predicate<IGridStack> filters = GridFilterParser.getFilters(grid, this.screen.getSearchFieldText(), grid.getTabSelected() >= 0 && grid.getTabSelected() < grid.getTabs().size() ? grid.getTabs().get(grid.getTabSelected()).getFilters() : grid.getFilters());
        if (this.screen.getGrid().getViewType() != 2) {
            return stack -> {
                if (stack.isCraftable() && stack.getOtherId() != null && this.map.containsKey(stack.getOtherId())) {
                    return false;
                }
                return filters.test((IGridStack)stack);
            };
        }
        return filters;
    }

    @Override
    public void setStacks(List<IGridStack> stacks) {
        this.map.clear();
        for (IGridStack stack : stacks) {
            this.map.put(stack.getId(), stack);
        }
    }

    @Override
    public void postChange(IGridStack stack, int delta) {
        IGridStack craftingStack;
        if (!this.active) {
            return;
        }
        if (!stack.isCraftable() && stack.getOtherId() != null && this.map.containsKey(stack.getOtherId())) {
            craftingStack = this.map.get(stack.getOtherId());
            craftingStack.updateOtherId(stack.getId());
            craftingStack.setTrackerEntry(stack.getTrackerEntry());
        } else {
            craftingStack = null;
        }
        IGridStack existing = this.map.get(stack.getId());
        boolean stillExists = true;
        boolean shouldSort = this.screen.canSort();
        if (existing == null) {
            stack.setQuantity(delta);
            this.map.put(stack.getId(), stack);
            existing = stack;
            if (craftingStack != null && shouldSort) {
                this.stacks.remove(craftingStack);
            }
        } else {
            if (shouldSort) {
                this.stacks.remove(existing);
            }
            existing.setQuantity(existing.getQuantity() + delta);
            if (existing.getQuantity() <= 0) {
                this.map.remove(existing.getId());
                stillExists = false;
                if (craftingStack != null && shouldSort && this.getActiveFilters().test(craftingStack)) {
                    this.addStack(craftingStack);
                }
            }
            existing.setTrackerEntry(stack.getTrackerEntry());
        }
        if (shouldSort) {
            if (stillExists && this.getActiveFilters().test(existing)) {
                this.addStack(existing);
            }
            this.screen.updateScrollbar();
        }
    }

    private void addStack(IGridStack stack) {
        int insertionPos = Collections.binarySearch(this.stacks, stack, this.getActiveSort());
        if (insertionPos < 0) {
            insertionPos = -insertionPos - 1;
        }
        this.stacks.add(insertionPos, stack);
    }

    @Override
    public void setCanCraft(boolean canCraft) {
        this.canCraft = canCraft;
    }

    @Override
    public boolean canCraft() {
        return this.canCraft;
    }
}

