/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.setup;

import com.refinedmods.refinedstorage.RSBlocks;
import com.refinedmods.refinedstorage.RSContainers;
import com.refinedmods.refinedstorage.RSItems;
import com.refinedmods.refinedstorage.RSKeyBindings;
import com.refinedmods.refinedstorage.RSTiles;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.container.CrafterContainer;
import com.refinedmods.refinedstorage.container.CrafterManagerContainer;
import com.refinedmods.refinedstorage.container.slot.CrafterManagerSlot;
import com.refinedmods.refinedstorage.item.property.ControllerItemPropertyGetter;
import com.refinedmods.refinedstorage.item.property.NetworkItemPropertyGetter;
import com.refinedmods.refinedstorage.item.property.SecurityCardItemPropertyGetter;
import com.refinedmods.refinedstorage.render.BakedModelOverrideRegistry;
import com.refinedmods.refinedstorage.render.color.PatternItemColor;
import com.refinedmods.refinedstorage.render.model.DiskDriveBakedModel;
import com.refinedmods.refinedstorage.render.model.DiskManipulatorBakedModel;
import com.refinedmods.refinedstorage.render.model.FullbrightBakedModel;
import com.refinedmods.refinedstorage.render.model.PatternBakedModel;
import com.refinedmods.refinedstorage.render.model.PortableGridBakedModel;
import com.refinedmods.refinedstorage.render.resourcepack.ResourcePackListener;
import com.refinedmods.refinedstorage.render.tesr.StorageMonitorTileRenderer;
import com.refinedmods.refinedstorage.screen.ConstructorScreen;
import com.refinedmods.refinedstorage.screen.ControllerScreen;
import com.refinedmods.refinedstorage.screen.CrafterScreen;
import com.refinedmods.refinedstorage.screen.CraftingMonitorScreen;
import com.refinedmods.refinedstorage.screen.DestructorScreen;
import com.refinedmods.refinedstorage.screen.DetectorScreen;
import com.refinedmods.refinedstorage.screen.DiskDriveScreen;
import com.refinedmods.refinedstorage.screen.DiskManipulatorScreen;
import com.refinedmods.refinedstorage.screen.ExporterScreen;
import com.refinedmods.refinedstorage.screen.ExternalStorageScreen;
import com.refinedmods.refinedstorage.screen.FilterScreen;
import com.refinedmods.refinedstorage.screen.FluidInterfaceScreen;
import com.refinedmods.refinedstorage.screen.FluidStorageBlockScreen;
import com.refinedmods.refinedstorage.screen.ImporterScreen;
import com.refinedmods.refinedstorage.screen.InterfaceScreen;
import com.refinedmods.refinedstorage.screen.KeyInputListener;
import com.refinedmods.refinedstorage.screen.NetworkTransmitterScreen;
import com.refinedmods.refinedstorage.screen.RelayScreen;
import com.refinedmods.refinedstorage.screen.SecurityManagerScreen;
import com.refinedmods.refinedstorage.screen.StorageBlockScreen;
import com.refinedmods.refinedstorage.screen.StorageMonitorScreen;
import com.refinedmods.refinedstorage.screen.WirelessTransmitterScreen;
import com.refinedmods.refinedstorage.screen.factory.CrafterManagerScreenFactory;
import com.refinedmods.refinedstorage.screen.factory.GridScreenFactory;
import com.refinedmods.refinedstorage.util.ColorMap;
import java.util.Arrays;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.DyeColor;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientSetup {
    private static final ResourceLocation DISK_RESOURCE = new ResourceLocation("refinedstorage:block/disks/disk");
    private static final ResourceLocation DISK_NEAR_CAPACITY_RESOURCE = new ResourceLocation("refinedstorage:block/disks/disk_near_capacity");
    private static final ResourceLocation DISK_FULL_RESOURCE = new ResourceLocation("refinedstorage:block/disks/disk_full");
    private static final ResourceLocation DISK_DISCONNECTED_RESOURCE = new ResourceLocation("refinedstorage:block/disks/disk_disconnected");
    private static final ResourceLocation CONNECTED = new ResourceLocation("connected");
    private final BakedModelOverrideRegistry bakedModelOverrideRegistry = new BakedModelOverrideRegistry();

    public ClientSetup() {
        this.forEachColorApply("controller", (name, color) -> this.bakedModelOverrideRegistry.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, new ResourceLocation("refinedstorage", "block/controller/cutouts/" + color), new ResourceLocation("refinedstorage", "block/controller/cutouts/nearly_off"), new ResourceLocation("refinedstorage", "block/controller/cutouts/nearly_on"))));
        this.forEachColorApply("creative_controller", (name, color) -> this.bakedModelOverrideRegistry.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, new ResourceLocation("refinedstorage", "block/controller/cutouts/" + color), new ResourceLocation("refinedstorage", "block/controller/cutouts/nearly_off"), new ResourceLocation("refinedstorage", "block/controller/cutouts/nearly_on"))));
        this.forEachColorApply("grid", (name, color) -> this.bakedModelOverrideRegistry.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, this.getColoredModel((DyeColor)color, "block/grid/cutouts/"))));
        this.forEachColorApply("crafting_grid", (name, color) -> this.bakedModelOverrideRegistry.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, this.getColoredModel((DyeColor)color, "block/crafting_grid/cutouts/"))));
        this.forEachColorApply("pattern_grid", (name, color) -> this.bakedModelOverrideRegistry.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, this.getColoredModel((DyeColor)color, "block/pattern_grid/cutouts/"))));
        this.forEachColorApply("fluid_grid", (name, color) -> this.bakedModelOverrideRegistry.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, this.getColoredModel((DyeColor)color, "block/fluid_grid/cutouts/"))));
        this.forEachColorApply("network_receiver", (name, color) -> this.bakedModelOverrideRegistry.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, this.getColoredModel((DyeColor)color, "block/network_receiver/cutouts/"))));
        this.forEachColorApply("network_transmitter", (name, color) -> this.bakedModelOverrideRegistry.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, this.getColoredModel((DyeColor)color, "block/network_transmitter/cutouts/"))));
        this.forEachColorApply("relay", (name, color) -> this.bakedModelOverrideRegistry.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, this.getColoredModel((DyeColor)color, "block/relay/cutouts/"))));
        this.forEachColorApply("detector", (name, color) -> this.bakedModelOverrideRegistry.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, this.getColoredModel((DyeColor)color, "block/detector/cutouts/"))));
        this.forEachColorApply("security_manager", (name, color) -> this.bakedModelOverrideRegistry.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, this.getMultipleColoredModels((DyeColor)color, "block/security_manager/cutouts/top_", "block/security_manager/cutouts/front_", "block/security_manager/cutouts/left_", "block/security_manager/cutouts/back_", "block/security_manager/cutouts/right_"))));
        this.forEachColorApply("wireless_transmitter", (name, color) -> this.bakedModelOverrideRegistry.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, this.getColoredModel((DyeColor)color, "block/wireless_transmitter/cutouts/"))));
        this.bakedModelOverrideRegistry.add(new ResourceLocation("refinedstorage", "constructor"), (base, registry) -> new FullbrightBakedModel(base, true, new ResourceLocation("refinedstorage", "block/constructor/cutouts/connected")));
        this.bakedModelOverrideRegistry.add(new ResourceLocation("refinedstorage", "destructor"), (base, registry) -> new FullbrightBakedModel(base, true, new ResourceLocation("refinedstorage", "block/destructor/cutouts/connected")));
        this.bakedModelOverrideRegistry.add(new ResourceLocation("refinedstorage", "disk_drive"), (base, registry) -> new FullbrightBakedModel(new DiskDriveBakedModel(base, (IBakedModel)registry.get(DISK_RESOURCE), (IBakedModel)registry.get(DISK_NEAR_CAPACITY_RESOURCE), (IBakedModel)registry.get(DISK_FULL_RESOURCE), (IBakedModel)registry.get(DISK_DISCONNECTED_RESOURCE)), false, new ResourceLocation("refinedstorage", "block/disks/leds")));
        this.forEachColorApply("disk_manipulator", (name, color) -> this.bakedModelOverrideRegistry.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(new DiskManipulatorBakedModel((IBakedModel)registry.get(new ResourceLocation("refinedstorage:block/disk_manipulator/" + color)), (IBakedModel)registry.get(new ResourceLocation("refinedstorage:block/disk_manipulator/disconnected")), (IBakedModel)registry.get(DISK_RESOURCE), (IBakedModel)registry.get(DISK_NEAR_CAPACITY_RESOURCE), (IBakedModel)registry.get(DISK_FULL_RESOURCE), (IBakedModel)registry.get(DISK_DISCONNECTED_RESOURCE)), false, new ResourceLocation("refinedstorage", "block/disks/leds"), new ResourceLocation("refinedstorage", "block/disk_manipulator/cutouts/" + color))));
        for (String portableGridName : new String[]{"portable_grid", "creative_portable_grid"}) {
            this.bakedModelOverrideRegistry.add(new ResourceLocation("refinedstorage", portableGridName), (base, registry) -> new FullbrightBakedModel(new PortableGridBakedModel((IBakedModel)registry.get(new ResourceLocation("refinedstorage:block/portable_grid_connected")), (IBakedModel)registry.get(new ResourceLocation("refinedstorage:block/portable_grid_disconnected")), (IBakedModel)registry.get(new ResourceLocation("refinedstorage:block/disks/portable_grid_disk")), (IBakedModel)registry.get(new ResourceLocation("refinedstorage:block/disks/portable_grid_disk_near_capacity")), (IBakedModel)registry.get(new ResourceLocation("refinedstorage:block/disks/portable_grid_disk_full")), (IBakedModel)registry.get(new ResourceLocation("refinedstorage:block/disks/portable_grid_disk_disconnected"))), false, new ResourceLocation("refinedstorage:block/disks/leds")));
        }
        this.forEachColorApply("crafter", (name, color) -> this.bakedModelOverrideRegistry.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, this.getMultipleColoredModels((DyeColor)color, "block/crafter/cutouts/side_", "block/crafter/cutouts/top_"))));
        this.forEachColorApply("crafter_manager", (name, color) -> this.bakedModelOverrideRegistry.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, this.getColoredModel((DyeColor)color, "block/crafter_manager/cutouts/"))));
        this.forEachColorApply("crafting_monitor", (name, color) -> this.bakedModelOverrideRegistry.add((ResourceLocation)name, (base, registry) -> new FullbrightBakedModel(base, true, this.getColoredModel((DyeColor)color, "block/crafting_monitor/cutouts/"))));
        this.bakedModelOverrideRegistry.add(new ResourceLocation("refinedstorage", "pattern"), (base, registry) -> new PatternBakedModel(base));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onModelBake);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onModelRegistry);
        MinecraftForge.EVENT_BUS.addListener(this::addReloadListener);
        API.instance().addPatternRenderHandler(pattern -> Screen.func_231173_s_());
        API.instance().addPatternRenderHandler(pattern -> {
            Container container = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
            if (container instanceof CrafterManagerContainer) {
                for (Slot slot : container.field_75151_b) {
                    if (!(slot instanceof CrafterManagerSlot) || slot.func_75211_c() != pattern) continue;
                    return true;
                }
            }
            return false;
        });
        API.instance().addPatternRenderHandler(pattern -> {
            Container container = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
            if (container instanceof CrafterContainer) {
                for (int i = 0; i < 9; ++i) {
                    if (container.func_75139_a(i).func_75211_c() != pattern) continue;
                    return true;
                }
            }
            return false;
        });
    }

    private ResourceLocation[] getMultipleColoredModels(DyeColor color, String ... paths) {
        return (ResourceLocation[])Arrays.stream(paths).map(path -> this.getColoredModel(color, (String)path)).toArray(ResourceLocation[]::new);
    }

    private ResourceLocation getColoredModel(DyeColor color, String path) {
        return new ResourceLocation("refinedstorage", path + color);
    }

    private void forEachColorApply(String name, BiConsumer<ResourceLocation, DyeColor> consumer) {
        for (DyeColor color : DyeColor.values()) {
            String prefix = color == ColorMap.DEFAULT_COLOR ? "" : color + "_";
            consumer.accept(new ResourceLocation("refinedstorage", prefix + name), color);
        }
    }

    @SubscribeEvent
    public void onClientSetup(FMLClientSetupEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)new KeyInputListener());
        ScreenManager.func_216911_a(RSContainers.FILTER, FilterScreen::new);
        ScreenManager.func_216911_a(RSContainers.CONTROLLER, ControllerScreen::new);
        ScreenManager.func_216911_a(RSContainers.DISK_DRIVE, DiskDriveScreen::new);
        ScreenManager.func_216911_a(RSContainers.GRID, (ScreenManager.IScreenFactory)new GridScreenFactory());
        ScreenManager.func_216911_a(RSContainers.STORAGE_BLOCK, StorageBlockScreen::new);
        ScreenManager.func_216911_a(RSContainers.FLUID_STORAGE_BLOCK, FluidStorageBlockScreen::new);
        ScreenManager.func_216911_a(RSContainers.EXTERNAL_STORAGE, ExternalStorageScreen::new);
        ScreenManager.func_216911_a(RSContainers.IMPORTER, ImporterScreen::new);
        ScreenManager.func_216911_a(RSContainers.EXPORTER, ExporterScreen::new);
        ScreenManager.func_216911_a(RSContainers.NETWORK_TRANSMITTER, NetworkTransmitterScreen::new);
        ScreenManager.func_216911_a(RSContainers.RELAY, RelayScreen::new);
        ScreenManager.func_216911_a(RSContainers.DETECTOR, DetectorScreen::new);
        ScreenManager.func_216911_a(RSContainers.SECURITY_MANAGER, SecurityManagerScreen::new);
        ScreenManager.func_216911_a(RSContainers.INTERFACE, InterfaceScreen::new);
        ScreenManager.func_216911_a(RSContainers.FLUID_INTERFACE, FluidInterfaceScreen::new);
        ScreenManager.func_216911_a(RSContainers.WIRELESS_TRANSMITTER, WirelessTransmitterScreen::new);
        ScreenManager.func_216911_a(RSContainers.STORAGE_MONITOR, StorageMonitorScreen::new);
        ScreenManager.func_216911_a(RSContainers.CONSTRUCTOR, ConstructorScreen::new);
        ScreenManager.func_216911_a(RSContainers.DESTRUCTOR, DestructorScreen::new);
        ScreenManager.func_216911_a(RSContainers.DISK_MANIPULATOR, DiskManipulatorScreen::new);
        ScreenManager.func_216911_a(RSContainers.CRAFTER, CrafterScreen::new);
        ScreenManager.func_216911_a(RSContainers.CRAFTER_MANAGER, (ScreenManager.IScreenFactory)new CrafterManagerScreenFactory());
        ScreenManager.func_216911_a(RSContainers.CRAFTING_MONITOR, CraftingMonitorScreen::new);
        ScreenManager.func_216911_a(RSContainers.WIRELESS_CRAFTING_MONITOR, CraftingMonitorScreen::new);
        ClientRegistry.registerKeyBinding((KeyBinding)RSKeyBindings.FOCUS_SEARCH_BAR);
        ClientRegistry.registerKeyBinding((KeyBinding)RSKeyBindings.CLEAR_GRID_CRAFTING_MATRIX);
        ClientRegistry.registerKeyBinding((KeyBinding)RSKeyBindings.OPEN_WIRELESS_GRID);
        ClientRegistry.registerKeyBinding((KeyBinding)RSKeyBindings.OPEN_WIRELESS_FLUID_GRID);
        ClientRegistry.registerKeyBinding((KeyBinding)RSKeyBindings.OPEN_WIRELESS_CRAFTING_MONITOR);
        ClientRegistry.registerKeyBinding((KeyBinding)RSKeyBindings.OPEN_PORTABLE_GRID);
        RSBlocks.CONTROLLER.values().forEach(block -> RenderTypeLookup.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.func_228643_e_()));
        RSBlocks.CREATIVE_CONTROLLER.values().forEach(block -> RenderTypeLookup.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.func_228643_e_()));
        RSBlocks.CRAFTER.values().forEach(block -> RenderTypeLookup.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.func_228643_e_()));
        RSBlocks.CRAFTER_MANAGER.values().forEach(block -> RenderTypeLookup.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.func_228643_e_()));
        RSBlocks.CRAFTING_MONITOR.values().forEach(block -> RenderTypeLookup.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.func_228643_e_()));
        RSBlocks.DETECTOR.values().forEach(block -> RenderTypeLookup.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.func_228643_e_()));
        RSBlocks.DISK_MANIPULATOR.values().forEach(block -> RenderTypeLookup.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.func_228643_e_()));
        RSBlocks.GRID.values().forEach(block -> RenderTypeLookup.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.func_228643_e_()));
        RSBlocks.CRAFTING_GRID.values().forEach(block -> RenderTypeLookup.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.func_228643_e_()));
        RSBlocks.PATTERN_GRID.values().forEach(block -> RenderTypeLookup.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.func_228643_e_()));
        RSBlocks.FLUID_GRID.values().forEach(block -> RenderTypeLookup.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.func_228643_e_()));
        RSBlocks.NETWORK_RECEIVER.values().forEach(block -> RenderTypeLookup.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.func_228643_e_()));
        RSBlocks.NETWORK_TRANSMITTER.values().forEach(block -> RenderTypeLookup.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.func_228643_e_()));
        RSBlocks.RELAY.values().forEach(block -> RenderTypeLookup.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.func_228643_e_()));
        RSBlocks.SECURITY_MANAGER.values().forEach(block -> RenderTypeLookup.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.func_228643_e_()));
        RSBlocks.WIRELESS_TRANSMITTER.values().forEach(block -> RenderTypeLookup.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.func_228643_e_()));
        RenderTypeLookup.setRenderLayer((Block)((Block)RSBlocks.CABLE.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)RSBlocks.IMPORTER.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)RSBlocks.EXPORTER.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)RSBlocks.EXTERNAL_STORAGE.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)RSBlocks.CONSTRUCTOR.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)RSBlocks.DESTRUCTOR.get()), (RenderType)RenderType.func_228643_e_());
        ClientRegistry.bindTileEntityRenderer(RSTiles.STORAGE_MONITOR, StorageMonitorTileRenderer::new);
        ((Minecraft)e.getMinecraftSupplier().get()).getItemColors().func_199877_a((IItemColor)new PatternItemColor(), new IItemProvider[]{(IItemProvider)RSItems.PATTERN.get()});
        ItemModelsProperties.func_239418_a_((Item)((Item)RSItems.SECURITY_CARD.get()), (ResourceLocation)new ResourceLocation("active"), (IItemPropertyGetter)new SecurityCardItemPropertyGetter());
        RSItems.CONTROLLER.values().forEach(controller -> ItemModelsProperties.func_239418_a_((Item)((Item)controller.get()), (ResourceLocation)new ResourceLocation("energy_type"), (IItemPropertyGetter)new ControllerItemPropertyGetter()));
        RSItems.CREATIVE_CONTROLLER.values().forEach(controller -> ItemModelsProperties.func_239418_a_((Item)((Item)controller.get()), (ResourceLocation)new ResourceLocation("energy_type"), (IItemPropertyGetter)new ControllerItemPropertyGetter()));
        ItemModelsProperties.func_239418_a_((Item)((Item)RSItems.WIRELESS_CRAFTING_MONITOR.get()), (ResourceLocation)CONNECTED, (IItemPropertyGetter)new NetworkItemPropertyGetter());
        ItemModelsProperties.func_239418_a_((Item)((Item)RSItems.CREATIVE_WIRELESS_CRAFTING_MONITOR.get()), (ResourceLocation)CONNECTED, (IItemPropertyGetter)new NetworkItemPropertyGetter());
        ItemModelsProperties.func_239418_a_((Item)((Item)RSItems.WIRELESS_GRID.get()), (ResourceLocation)CONNECTED, (IItemPropertyGetter)new NetworkItemPropertyGetter());
        ItemModelsProperties.func_239418_a_((Item)((Item)RSItems.CREATIVE_WIRELESS_GRID.get()), (ResourceLocation)CONNECTED, (IItemPropertyGetter)new NetworkItemPropertyGetter());
        ItemModelsProperties.func_239418_a_((Item)((Item)RSItems.WIRELESS_FLUID_GRID.get()), (ResourceLocation)CONNECTED, (IItemPropertyGetter)new NetworkItemPropertyGetter());
        ItemModelsProperties.func_239418_a_((Item)((Item)RSItems.CREATIVE_WIRELESS_FLUID_GRID.get()), (ResourceLocation)CONNECTED, (IItemPropertyGetter)new NetworkItemPropertyGetter());
    }

    @SubscribeEvent
    public void addReloadListener(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)new ResourcePackListener());
    }

    @SubscribeEvent
    public void onModelRegistry(ModelRegistryEvent e) {
        ModelLoader.addSpecialModel((ResourceLocation)DISK_RESOURCE);
        ModelLoader.addSpecialModel((ResourceLocation)DISK_NEAR_CAPACITY_RESOURCE);
        ModelLoader.addSpecialModel((ResourceLocation)DISK_FULL_RESOURCE);
        ModelLoader.addSpecialModel((ResourceLocation)DISK_DISCONNECTED_RESOURCE);
        ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("refinedstorage:block/disk_manipulator/disconnected"));
        for (DyeColor color : DyeColor.values()) {
            ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("refinedstorage:block/disk_manipulator/" + color));
        }
        ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("refinedstorage:block/portable_grid_connected"));
        ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("refinedstorage:block/portable_grid_disconnected"));
        ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("refinedstorage:block/disks/portable_grid_disk"));
        ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("refinedstorage:block/disks/portable_grid_disk_near_capacity"));
        ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("refinedstorage:block/disks/portable_grid_disk_full"));
        ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("refinedstorage:block/disks/portable_grid_disk_disconnected"));
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent e) {
        FullbrightBakedModel.invalidateCache();
        for (ResourceLocation id : e.getModelRegistry().keySet()) {
            BakedModelOverrideRegistry.BakedModelOverrideFactory factory = this.bakedModelOverrideRegistry.get(new ResourceLocation(id.func_110624_b(), id.func_110623_a()));
            if (factory == null) continue;
            e.getModelRegistry().put(id, factory.create((IBakedModel)e.getModelRegistry().get(id), e.getModelRegistry()));
        }
    }
}

