/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.tile.grid.portable;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.RSTiles;
import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.api.network.grid.ICraftingGridListener;
import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.api.network.grid.IGridTab;
import com.refinedmods.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.refinedmods.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.api.storage.StorageType;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCache;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCacheListener;
import com.refinedmods.refinedstorage.api.storage.cache.InvalidateCause;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskProvider;
import com.refinedmods.refinedstorage.api.storage.tracker.IStorageTracker;
import com.refinedmods.refinedstorage.api.util.IFilter;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.grid.handler.PortableFluidGridHandler;
import com.refinedmods.refinedstorage.apiimpl.network.grid.handler.PortableItemGridHandler;
import com.refinedmods.refinedstorage.apiimpl.storage.cache.PortableFluidStorageCache;
import com.refinedmods.refinedstorage.apiimpl.storage.cache.PortableItemStorageCache;
import com.refinedmods.refinedstorage.apiimpl.storage.cache.listener.PortableFluidGridStorageCacheListener;
import com.refinedmods.refinedstorage.apiimpl.storage.cache.listener.PortableItemGridStorageCacheListener;
import com.refinedmods.refinedstorage.apiimpl.storage.disk.PortableFluidStorageDisk;
import com.refinedmods.refinedstorage.apiimpl.storage.disk.PortableItemStorageDisk;
import com.refinedmods.refinedstorage.apiimpl.storage.tracker.FluidStorageTracker;
import com.refinedmods.refinedstorage.apiimpl.storage.tracker.ItemStorageTracker;
import com.refinedmods.refinedstorage.block.PortableGridBlock;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.FilterItemHandler;
import com.refinedmods.refinedstorage.inventory.item.validator.StorageDiskItemValidator;
import com.refinedmods.refinedstorage.inventory.listener.TileInventoryListener;
import com.refinedmods.refinedstorage.item.WirelessGridItem;
import com.refinedmods.refinedstorage.item.blockitem.PortableGridBlockItem;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.grid.GridScreen;
import com.refinedmods.refinedstorage.tile.BaseTile;
import com.refinedmods.refinedstorage.tile.config.IRedstoneConfigurable;
import com.refinedmods.refinedstorage.tile.config.RedstoneMode;
import com.refinedmods.refinedstorage.tile.data.TileDataManager;
import com.refinedmods.refinedstorage.tile.data.TileDataParameter;
import com.refinedmods.refinedstorage.tile.grid.GridTile;
import com.refinedmods.refinedstorage.tile.grid.portable.IPortableGrid;
import com.refinedmods.refinedstorage.tile.grid.portable.PortableGridDiskState;
import com.refinedmods.refinedstorage.util.StackUtils;
import com.refinedmods.refinedstorage.util.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class PortableGridTile
extends BaseTile
implements ITickableTileEntity,
IGrid,
IPortableGrid,
IRedstoneConfigurable,
IStorageDiskContainerContext {
    public static final TileDataParameter<Integer, PortableGridTile> REDSTONE_MODE = RedstoneMode.createParameter();
    private static final TileDataParameter<Integer, PortableGridTile> SORTING_DIRECTION = new TileDataParameter<Integer, PortableGridTile>(DataSerializers.field_187192_b, 0, PortableGridTile::getSortingDirection, (t, v) -> {
        if (IGrid.isValidSortingDirection(v)) {
            t.setSortingDirection((int)v);
            t.func_70296_d();
        }
    }, (initial, p) -> GridTile.trySortGrid(initial));
    private static final TileDataParameter<Integer, PortableGridTile> SORTING_TYPE = new TileDataParameter<Integer, PortableGridTile>(DataSerializers.field_187192_b, 0, PortableGridTile::getSortingType, (t, v) -> {
        if (IGrid.isValidSortingType(v)) {
            t.setSortingType((int)v);
            t.func_70296_d();
        }
    }, (initial, p) -> GridTile.trySortGrid(initial));
    private static final TileDataParameter<Integer, PortableGridTile> SEARCH_BOX_MODE = new TileDataParameter<Integer, PortableGridTile>(DataSerializers.field_187192_b, 0, PortableGridTile::getSearchBoxMode, (t, v) -> {
        if (IGrid.isValidSearchBoxMode(v)) {
            t.setSearchBoxMode((int)v);
            t.func_70296_d();
        }
    }, (initial, p) -> BaseScreen.executeLater(GridScreen.class, grid -> grid.getSearchField().setMode((int)p)));
    private static final TileDataParameter<Integer, PortableGridTile> SIZE = new TileDataParameter<Integer, PortableGridTile>(DataSerializers.field_187192_b, 0, PortableGridTile::getSize, (t, v) -> {
        if (IGrid.isValidSize(v)) {
            t.setSize((int)v);
            t.func_70296_d();
        }
    }, (initial, p) -> BaseScreen.executeLater(GridScreen.class, BaseScreen::func_231160_c_));
    private static final TileDataParameter<Integer, PortableGridTile> TAB_SELECTED = new TileDataParameter<Integer, PortableGridTile>(DataSerializers.field_187192_b, 0, PortableGridTile::getTabSelected, (t, v) -> {
        t.setTabSelected(v.intValue() == t.getTabSelected() ? -1 : v);
        t.func_70296_d();
    }, (initial, p) -> BaseScreen.executeLater(GridScreen.class, grid -> grid.getView().sort()));
    private static final TileDataParameter<Integer, PortableGridTile> TAB_PAGE = new TileDataParameter<Integer, PortableGridTile>(DataSerializers.field_187192_b, 0, PortableGridTile::getTabPage, (t, v) -> {
        if (v >= 0 && v <= t.getTotalTabPages()) {
            t.setTabPage((int)v);
            t.func_70296_d();
        }
    });
    private static final String NBT_STORAGE_TRACKER = "StorageTracker";
    private static final String NBT_FLUID_STORAGE_TRACKER = "FluidStorageTracker";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_ENERGY = "Energy";
    private static final String NBT_ENCHANTMENTS = "Enchantments";
    private EnergyStorage energyStorage = this.createEnergyStorage(0);
    private final LazyOptional<EnergyStorage> energyStorageCap = LazyOptional.of(() -> this.energyStorage);
    private final PortableGridBlockItem.Type type;
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    private int sortingType;
    private int sortingDirection;
    private int searchBoxMode;
    private int tabSelected;
    private int tabPage;
    private int size;
    private GridType clientGridType;
    private final List<IFilter> filters = new ArrayList<IFilter>();
    private final List<IGridTab> tabs = new ArrayList<IGridTab>();
    private final FilterItemHandler filter = (FilterItemHandler)new FilterItemHandler(this.filters, this.tabs).addListener(new TileInventoryListener(this));
    private final BaseItemHandler disk = new BaseItemHandler(1).addValidator(new StorageDiskItemValidator()).addListener(new TileInventoryListener(this)).addListener((handler, slot, reading) -> {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.loadStorage();
            if (!reading) {
                this.updateState();
                WorldUtils.updateBlock(this.field_145850_b, this.field_174879_c);
            }
        }
    });
    @Nullable
    private IStorageDisk storage;
    @Nullable
    private IStorageCache cache;
    private final PortableItemGridHandler itemHandler = new PortableItemGridHandler(this, this);
    private final PortableFluidGridHandler fluidHandler = new PortableFluidGridHandler(this);
    private PortableGridDiskState diskState = PortableGridDiskState.NONE;
    private boolean active;
    private final ItemStorageTracker storageTracker = new ItemStorageTracker(this::func_70296_d);
    private final FluidStorageTracker fluidStorageTracker = new FluidStorageTracker(this::func_70296_d);
    private ListNBT enchants = null;
    private boolean loadNextTick;

    public PortableGridTile(PortableGridBlockItem.Type type) {
        super(type == PortableGridBlockItem.Type.CREATIVE ? RSTiles.CREATIVE_PORTABLE_GRID : RSTiles.PORTABLE_GRID);
        this.type = type;
        this.dataManager.addWatchedParameter(REDSTONE_MODE);
        this.dataManager.addWatchedParameter(SORTING_DIRECTION);
        this.dataManager.addWatchedParameter(SORTING_TYPE);
        this.dataManager.addWatchedParameter(SEARCH_BOX_MODE);
        this.dataManager.addWatchedParameter(SIZE);
        this.dataManager.addWatchedParameter(TAB_SELECTED);
        this.dataManager.addWatchedParameter(TAB_PAGE);
    }

    private void loadStorage() {
        ItemStack diskStack = this.getDiskInventory().getStackInSlot(0);
        if (diskStack.func_190926_b()) {
            this.storage = null;
            this.cache = null;
        } else {
            IStorageDisk diskInSlot = API.instance().getStorageDiskManager((ServerWorld)this.field_145850_b).getByStack(this.getDiskInventory().getStackInSlot(0));
            if (diskInSlot != null) {
                StorageType diskType = ((IStorageDiskProvider)this.getDiskInventory().getStackInSlot(0).func_77973_b()).getType();
                if (diskType == StorageType.ITEM) {
                    this.storage = new PortableItemStorageDisk(diskInSlot, this);
                    this.cache = new PortableItemStorageCache(this);
                } else if (diskType == StorageType.FLUID) {
                    this.storage = new PortableFluidStorageDisk(diskInSlot, this);
                    this.cache = new PortableFluidStorageCache(this);
                }
                this.storage.setSettings(this::updateState, this);
            } else {
                this.storage = null;
                this.cache = null;
            }
        }
        if (this.cache != null) {
            this.cache.invalidate(InvalidateCause.DISK_INVENTORY_CHANGED);
        }
    }

    public void onLoad() {
        super.onLoad();
        this.loadStorage();
        this.loadNextTick = true;
    }

    public void applyDataFromItemToTile(ItemStack stack) {
        this.sortingType = WirelessGridItem.getSortingType(stack);
        this.sortingDirection = WirelessGridItem.getSortingDirection(stack);
        this.searchBoxMode = WirelessGridItem.getSearchBoxMode(stack);
        this.tabSelected = WirelessGridItem.getTabSelected(stack);
        this.tabPage = WirelessGridItem.getTabPage(stack);
        this.size = WirelessGridItem.getSize(stack);
        this.energyStorage = this.createEnergyStorage(stack.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0));
        if (stack.func_77942_o()) {
            for (int i = 0; i < 4; ++i) {
                StackUtils.readItems(this.filter, i, stack.func_77978_p());
            }
            StackUtils.readItems(this.disk, 4, stack.func_77978_p());
            this.redstoneMode = RedstoneMode.read(stack.func_77978_p());
            if (stack.func_77978_p().func_74764_b(NBT_STORAGE_TRACKER)) {
                this.storageTracker.readFromNbt(stack.func_77978_p().func_150295_c(NBT_STORAGE_TRACKER, 10));
            }
            if (stack.func_77978_p().func_74764_b(NBT_FLUID_STORAGE_TRACKER)) {
                this.fluidStorageTracker.readFromNbt(stack.func_77978_p().func_150295_c(NBT_FLUID_STORAGE_TRACKER, 10));
            }
            if (stack.func_77978_p().func_74764_b(NBT_ENCHANTMENTS)) {
                this.enchants = stack.func_77978_p().func_150295_c(NBT_ENCHANTMENTS, 10);
            }
        }
        this.func_70296_d();
    }

    public void applyDataFromTileToItem(ItemStack stack) {
        stack.func_77982_d(new CompoundNBT());
        stack.func_77978_p().func_74768_a("SortingDirection", this.sortingDirection);
        stack.func_77978_p().func_74768_a("SortingType", this.sortingType);
        stack.func_77978_p().func_74768_a("SearchBoxMode", this.searchBoxMode);
        stack.func_77978_p().func_74768_a("Size", this.size);
        stack.func_77978_p().func_74768_a("TabSelected", this.tabSelected);
        stack.func_77978_p().func_74768_a("TabPage", this.tabPage);
        stack.func_77978_p().func_218657_a(NBT_STORAGE_TRACKER, (INBT)this.storageTracker.serializeNbt());
        stack.func_77978_p().func_218657_a(NBT_FLUID_STORAGE_TRACKER, (INBT)this.fluidStorageTracker.serializeNbt());
        if (this.enchants != null) {
            stack.func_77978_p().func_218657_a(NBT_ENCHANTMENTS, (INBT)this.enchants);
        }
        stack.getCapability(CapabilityEnergy.ENERGY, null).ifPresent(itemEnergy -> itemEnergy.receiveEnergy(this.energyStorage.getEnergyStored(), false));
        for (int i = 0; i < 4; ++i) {
            StackUtils.writeItems((IItemHandler)this.filter, i, stack.func_77978_p());
        }
        StackUtils.writeItems((IItemHandler)this.disk, 4, stack.func_77978_p());
        this.redstoneMode.write(stack.func_77978_p());
    }

    private EnergyStorage createEnergyStorage(int energyStored) {
        return new EnergyStorage(RS.SERVER_CONFIG.getPortableGrid().getCapacity(), RS.SERVER_CONFIG.getPortableGrid().getCapacity(), RS.SERVER_CONFIG.getPortableGrid().getCapacity(), energyStored);
    }

    @Override
    public GridType getGridType() {
        return this.clientGridType != null ? this.clientGridType : this.getServerGridType();
    }

    private GridType getServerGridType() {
        return this.getDiskInventory().getStackInSlot(0).func_190926_b() || ((IStorageDiskProvider)this.getDiskInventory().getStackInSlot(0).func_77973_b()).getType() == StorageType.ITEM ? GridType.NORMAL : GridType.FLUID;
    }

    @Override
    @Nullable
    public IStorageCache getStorageCache() {
        return this.storage != null ? this.cache : null;
    }

    @Override
    public IStorageCacheListener createListener(ServerPlayerEntity player) {
        return this.getServerGridType() == GridType.FLUID ? new PortableFluidGridStorageCacheListener(this, player) : new PortableItemGridStorageCacheListener(this, player);
    }

    @Override
    @Nullable
    public IItemGridHandler getItemHandler() {
        return this.itemHandler;
    }

    @Override
    @Nullable
    public IFluidGridHandler getFluidHandler() {
        return this.fluidHandler;
    }

    @Override
    public void addCraftingListener(ICraftingGridListener listener) {
    }

    @Override
    public void removeCraftingListener(ICraftingGridListener listener) {
    }

    @Override
    public ITextComponent getTitle() {
        return new TranslationTextComponent("gui.refinedstorage.portable_grid");
    }

    @Override
    public int getViewType() {
        return -1;
    }

    @Override
    public int getSortingType() {
        return this.field_145850_b.field_72995_K ? SORTING_TYPE.getValue() : this.sortingType;
    }

    @Override
    public int getSortingDirection() {
        return this.field_145850_b.field_72995_K ? SORTING_DIRECTION.getValue() : this.sortingDirection;
    }

    @Override
    public int getSearchBoxMode() {
        return this.field_145850_b.field_72995_K ? SEARCH_BOX_MODE.getValue() : this.searchBoxMode;
    }

    @Override
    public int getTabSelected() {
        return this.field_145850_b.field_72995_K ? TAB_SELECTED.getValue() : this.tabSelected;
    }

    @Override
    public int getTabPage() {
        return this.field_145850_b.field_72995_K ? TAB_PAGE.getValue() : Math.min(this.tabPage, this.getTotalTabPages());
    }

    @Override
    public int getTotalTabPages() {
        return (int)Math.floor((float)Math.max(0, this.tabs.size() - 1) / 5.0f);
    }

    @Override
    public int getSize() {
        return this.field_145850_b.field_72995_K ? SIZE.getValue() : this.size;
    }

    public void setSortingType(int sortingType) {
        this.sortingType = sortingType;
    }

    public void setSortingDirection(int sortingDirection) {
        this.sortingDirection = sortingDirection;
    }

    public void setSearchBoxMode(int searchBoxMode) {
        this.searchBoxMode = searchBoxMode;
    }

    public void setTabSelected(int tabSelected) {
        this.tabSelected = tabSelected;
    }

    public void setTabPage(int page) {
        this.tabPage = page;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public void onViewTypeChanged(int type) {
    }

    @Override
    public void onSortingTypeChanged(int type) {
        TileDataManager.setParameter(SORTING_TYPE, type);
    }

    @Override
    public void onSortingDirectionChanged(int direction) {
        TileDataManager.setParameter(SORTING_DIRECTION, direction);
    }

    @Override
    public void onSearchBoxModeChanged(int searchBoxMode) {
        TileDataManager.setParameter(SEARCH_BOX_MODE, searchBoxMode);
    }

    @Override
    public void onSizeChanged(int size) {
        TileDataManager.setParameter(SIZE, size);
    }

    @Override
    public void onTabSelectionChanged(int tab) {
        TileDataManager.setParameter(TAB_SELECTED, tab);
    }

    @Override
    public void onTabPageChanged(int page) {
        if (page >= 0 && page <= this.getTotalTabPages()) {
            TileDataManager.setParameter(TAB_PAGE, page);
        }
    }

    @Override
    public List<IFilter> getFilters() {
        return this.filters;
    }

    @Override
    public List<IGridTab> getTabs() {
        return this.tabs;
    }

    @Override
    public IItemHandlerModifiable getFilter() {
        return this.filter;
    }

    @Override
    public IStorageTracker<ItemStack> getItemStorageTracker() {
        return this.storageTracker;
    }

    @Override
    public IStorageTracker<FluidStack> getFluidStorageTracker() {
        return this.fluidStorageTracker;
    }

    @Override
    public CraftingInventory getCraftingMatrix() {
        return null;
    }

    @Override
    public CraftResultInventory getCraftingResult() {
        return null;
    }

    @Override
    public void onCraftingMatrixChanged() {
    }

    @Override
    public void onCrafted(PlayerEntity player, @Nullable IStackList<ItemStack> availableItems, @Nullable IStackList<ItemStack> usedItems) {
    }

    @Override
    public void onClear(PlayerEntity player) {
    }

    @Override
    public void onCraftedShift(PlayerEntity player) {
    }

    @Override
    public void onRecipeTransfer(PlayerEntity player, ItemStack[][] recipe) {
    }

    @Override
    public void onClosed(PlayerEntity player) {
    }

    private boolean hasDisk() {
        return !this.disk.getStackInSlot(0).func_190926_b();
    }

    @Override
    public boolean isGridActive() {
        if (this.field_145850_b.field_72995_K) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_177230_c() instanceof PortableGridBlock) {
                return (Boolean)state.func_177229_b((Property)PortableGridBlock.ACTIVE);
            }
            return false;
        }
        if (RS.SERVER_CONFIG.getPortableGrid().getUseEnergy() && this.type != PortableGridBlockItem.Type.CREATIVE && this.energyStorage.getEnergyStored() <= RS.SERVER_CONFIG.getPortableGrid().getOpenUsage()) {
            return false;
        }
        if (!this.hasDisk()) {
            return false;
        }
        return this.redstoneMode.isEnabled(this.field_145850_b.func_175640_z(this.field_174879_c));
    }

    @Override
    public int getSlotId() {
        return -1;
    }

    @Override
    @Nullable
    public IStorageCache getCache() {
        return this.cache;
    }

    @Override
    @Nullable
    public IStorageDisk getStorage() {
        return this.storage;
    }

    @Override
    public void drainEnergy(int energy) {
        if (RS.SERVER_CONFIG.getPortableGrid().getUseEnergy() && this.type != PortableGridBlockItem.Type.CREATIVE && this.redstoneMode.isEnabled(this.field_145850_b.func_175640_z(this.field_174879_c))) {
            this.energyStorage.extractEnergy(energy, false);
            this.updateState();
        }
    }

    @Override
    public int getEnergy() {
        if (RS.SERVER_CONFIG.getPortableGrid().getUseEnergy() && this.type != PortableGridBlockItem.Type.CREATIVE) {
            return this.energyStorage.getEnergyStored();
        }
        return RS.SERVER_CONFIG.getPortableGrid().getCapacity();
    }

    @Override
    public PortableGridDiskState getDiskState() {
        int capacity;
        if (!this.hasDisk()) {
            return PortableGridDiskState.NONE;
        }
        if (!this.isGridActive()) {
            return PortableGridDiskState.DISCONNECTED;
        }
        int stored = this.storage != null ? this.storage.getStored() : 0;
        int n = capacity = this.storage != null ? this.storage.getCapacity() : 0;
        if (stored == capacity) {
            return PortableGridDiskState.FULL;
        }
        if ((int)((float)stored / (float)capacity * 100.0f) >= 75) {
            return PortableGridDiskState.NEAR_CAPACITY;
        }
        return PortableGridDiskState.NORMAL;
    }

    public void updateState() {
        boolean isActive;
        PortableGridDiskState newDiskState = this.getDiskState();
        if (this.diskState != newDiskState) {
            this.diskState = newDiskState;
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a(PortableGridBlock.DISK_STATE, (Comparable)((Object)this.diskState)));
        }
        if (this.active != (isActive = this.isGridActive())) {
            this.active = isActive;
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)PortableGridBlock.ACTIVE, (Comparable)Boolean.valueOf(this.active)));
        }
    }

    @Override
    public BaseItemHandler getDiskInventory() {
        return this.disk;
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("SortingDirection", this.sortingDirection);
        tag.func_74768_a("SortingType", this.sortingType);
        tag.func_74768_a("SearchBoxMode", this.searchBoxMode);
        tag.func_74768_a("Size", this.size);
        tag.func_74768_a("TabSelected", this.tabSelected);
        tag.func_74768_a("TabPage", this.tabPage);
        StackUtils.writeItems((IItemHandler)this.disk, 0, tag);
        StackUtils.writeItems((IItemHandler)this.filter, 1, tag);
        tag.func_74768_a(NBT_ENERGY, this.energyStorage.getEnergyStored());
        this.redstoneMode.write(tag);
        tag.func_218657_a(NBT_STORAGE_TRACKER, (INBT)this.storageTracker.serializeNbt());
        tag.func_218657_a(NBT_FLUID_STORAGE_TRACKER, (INBT)this.fluidStorageTracker.serializeNbt());
        if (this.enchants != null) {
            tag.func_218657_a(NBT_ENCHANTMENTS, (INBT)this.enchants);
        }
        return tag;
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT tag) {
        super.func_230337_a_(blockState, tag);
        if (tag.func_74764_b("SortingDirection")) {
            this.sortingDirection = tag.func_74762_e("SortingDirection");
        }
        if (tag.func_74764_b("SortingType")) {
            this.sortingType = tag.func_74762_e("SortingType");
        }
        if (tag.func_74764_b("SearchBoxMode")) {
            this.searchBoxMode = tag.func_74762_e("SearchBoxMode");
        }
        if (tag.func_74764_b("Size")) {
            this.size = tag.func_74762_e("Size");
        }
        if (tag.func_74764_b("TabSelected")) {
            this.tabSelected = tag.func_74762_e("TabSelected");
        }
        if (tag.func_74764_b("TabPage")) {
            this.tabPage = tag.func_74762_e("TabPage");
        }
        StackUtils.readItems(this.disk, 0, tag);
        StackUtils.readItems(this.filter, 1, tag);
        if (tag.func_74764_b(NBT_ENERGY)) {
            this.energyStorage = this.createEnergyStorage(tag.func_74762_e(NBT_ENERGY));
        }
        this.redstoneMode = RedstoneMode.read(tag);
        if (tag.func_74764_b(NBT_STORAGE_TRACKER)) {
            this.storageTracker.readFromNbt(tag.func_150295_c(NBT_STORAGE_TRACKER, 10));
        }
        if (tag.func_74764_b(NBT_FLUID_STORAGE_TRACKER)) {
            this.fluidStorageTracker.readFromNbt(tag.func_150295_c(NBT_FLUID_STORAGE_TRACKER, 10));
        }
        if (tag.func_74764_b(NBT_ENCHANTMENTS)) {
            this.enchants = tag.func_150295_c(NBT_ENCHANTMENTS, 10);
        }
    }

    @Override
    public CompoundNBT writeUpdate(CompoundNBT tag) {
        tag.func_74768_a(NBT_TYPE, this.getServerGridType().ordinal());
        return super.writeUpdate(tag);
    }

    @Override
    public void readUpdate(CompoundNBT tag) {
        super.readUpdate(tag);
        this.clientGridType = GridType.values()[tag.func_74762_e(NBT_TYPE)];
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyStorageCap.cast();
        }
        return super.getCapability(cap, direction);
    }

    public void onOpened() {
        this.drainEnergy(RS.SERVER_CONFIG.getPortableGrid().getOpenUsage());
    }

    @Override
    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void setRedstoneMode(RedstoneMode mode) {
        this.redstoneMode = mode;
        this.func_70296_d();
    }

    @Override
    public AccessType getAccessType() {
        return AccessType.INSERT_EXTRACT;
    }

    public void func_73660_a() {
        if (this.loadNextTick) {
            this.active = this.isGridActive();
            this.diskState = this.getDiskState();
            this.loadNextTick = false;
        }
    }
}

