/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.item.tool;

import com.blakebr0.cucumber.helper.BlockHelper;
import com.blakebr0.cucumber.iface.IEnableable;
import java.util.HashSet;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class BaseSickleItem
extends ToolItem {
    private final float attackDamage;
    private final float attackSpeed;
    private final int range;

    public BaseSickleItem(IItemTier tier, float attackDamage, float attackSpeed, int range, Function<Item.Properties, Item.Properties> properties) {
        super(attackDamage, attackSpeed, tier, new HashSet(), properties.apply(new Item.Properties()));
        this.attackDamage = attackDamage;
        this.attackSpeed = attackSpeed;
        this.range = range;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this instanceof IEnableable) {
            IEnableable enableable = (IEnableable)((Object)this);
            if (enableable.isEnabled()) {
                super.func_150895_a(group, items);
            }
        } else {
            super.func_150895_a(group, items);
        }
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        return BaseSickleItem.isValidMaterial(state) ? this.func_200891_e().func_200928_b() / 2.0f : super.func_150893_a(stack, state);
    }

    public boolean canHarvestBlock(ItemStack stack, BlockState state) {
        return BaseSickleItem.isValidMaterial(state);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        World world = player.func_130014_f_();
        return !this.harvest(stack, world, pos, player);
    }

    public float func_234675_d_() {
        return this.attackDamage + this.func_200891_e().func_200929_c();
    }

    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    private boolean harvest(ItemStack stack, World world, BlockPos pos, PlayerEntity player) {
        BlockState state = world.func_180495_p(pos);
        float hardness = state.func_185887_b((IBlockReader)world, pos);
        if (!this.tryHarvest(world, pos, false, stack, player) || !BaseSickleItem.isValidMaterial(state)) {
            return false;
        }
        int radius = this.range;
        if (radius > 0) {
            BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-radius, -radius, -radius), (BlockPos)pos.func_177982_a(radius, radius, radius)).forEach(aoePos -> {
                BlockState aoeState;
                float aoeHardness;
                if (aoePos != pos && (aoeHardness = (aoeState = world.func_180495_p(aoePos)).func_185887_b((IBlockReader)world, aoePos)) <= hardness + 5.0f && BaseSickleItem.isValidMaterial(aoeState) && this.tryHarvest(world, (BlockPos)aoePos, true, stack, player) && aoeHardness <= 0.0f && Math.random() < 0.33 && !player.field_71075_bZ.field_75098_d) {
                    stack.func_222118_a(1, (LivingEntity)player, entity -> entity.func_213334_d(player.func_184600_cs()));
                }
            });
        }
        return true;
    }

    private boolean tryHarvest(World world, BlockPos pos, boolean extra, ItemStack stack, PlayerEntity player) {
        boolean harvest;
        BlockState state = world.func_180495_p(pos);
        float hardness = state.func_185887_b((IBlockReader)world, pos);
        boolean bl = harvest = !extra || ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)player, (IBlockReader)world, (BlockPos)pos) || this.canHarvestBlock(stack, state);
        if (hardness >= 0.0f && harvest) {
            return BlockHelper.breakBlocksAOE(stack, world, player, pos, !extra);
        }
        return false;
    }

    private static boolean isValidMaterial(BlockState state) {
        Material material = state.func_185904_a();
        return material == Material.field_151584_j || material == Material.field_151585_k || material == Material.field_151582_l;
    }
}

