/*
 * Decompiled with CFR 0.152.
 */
package jeresources.profiling;

import java.util.HashMap;
import java.util.Map;
import jeresources.json.WorldGenAdapter;
import jeresources.util.DimensionHelper;
import net.minecraft.command.ICommandSource;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ProfilingTimer {
    private final ICommandSource sender;
    private int totalChunks;
    private final Map<RegistryKey<World>, DimensionCounters> dimensionsMap = new HashMap<RegistryKey<World>, DimensionCounters>();

    public ProfilingTimer(ICommandSource sender, int chunkCount) {
        this.sender = sender;
        this.totalChunks = chunkCount;
    }

    public void startChunk(RegistryKey<World> worldRegistryKey) {
        DimensionCounters counters = this.dimensionsMap.get(worldRegistryKey);
        if (counters == null) {
            counters = new DimensionCounters();
            this.dimensionsMap.put(worldRegistryKey, counters);
            this.send("[" + DimensionHelper.getWorldName(worldRegistryKey) + "] Started profiling");
        }
        ++counters.threadCounter;
    }

    public void endChunk(RegistryKey<World> worldRegistryKey) {
        DimensionCounters counters = this.dimensionsMap.get(worldRegistryKey);
        --counters.threadCounter;
        if (++counters.chunkCounter % 100 == 0) {
            this.sendSpeed(worldRegistryKey);
        }
        if (this.totalChunks == counters.chunkCounter) {
            counters.completed = true;
        }
    }

    public void complete() {
        for (RegistryKey<World> worldRegistryKey : this.dimensionsMap.keySet()) {
            DimensionCounters counters = this.dimensionsMap.get(worldRegistryKey);
            counters.completed = true;
            this.send("[" + DimensionHelper.getWorldName(worldRegistryKey) + "] Completed profiling of " + this.getBlocksPerLayer(worldRegistryKey) * 256L + " blocks in " + (System.currentTimeMillis() - counters.start) + " ms saved to " + WorldGenAdapter.getWorldGenFile());
        }
    }

    public synchronized boolean isCompleted() {
        for (DimensionCounters counters : this.dimensionsMap.values()) {
            if (counters.completed) continue;
            return false;
        }
        return true;
    }

    private void send(String s) {
        this.sender.func_145747_a((ITextComponent)new TranslationTextComponent(s), Util.field_240973_b_);
    }

    private void sendSpeed(RegistryKey<World> worldRegistryKey) {
        DimensionCounters counters = this.dimensionsMap.get(worldRegistryKey);
        float time = (float)(System.currentTimeMillis() - counters.start) * 1.0f / (float)counters.chunkCounter;
        String message = "[" + DimensionHelper.getWorldName(worldRegistryKey) + "] Scanned " + counters.chunkCounter + " chunks at " + String.format("%3.2f", Float.valueOf(time)) + " ms/chunk";
        this.send(message);
    }

    public long getBlocksPerLayer(RegistryKey<World> worldRegistryKey) {
        DimensionCounters counters = this.dimensionsMap.get(worldRegistryKey);
        return counters.chunkCounter * 16 * 16;
    }

    private static class DimensionCounters {
        public final long start = System.currentTimeMillis();
        public int chunkCounter;
        public int threadCounter;
        public boolean completed;

        private DimensionCounters() {
        }
    }
}

