/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.FloatBuffer;
import jeresources.api.render.ColorHelper;
import jeresources.api.render.IMobRenderHook;
import jeresources.api.render.IScissorHook;
import jeresources.compatibility.MobRegistryImpl;
import jeresources.reference.Resources;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class RenderHelper {
    public static void drawArrow(double xBegin, double yBegin, double xEnd, double yEnd, int color) {
        double scale = RenderHelper.getGuiScaleFactor();
        ColorHelper.setColor3f(color);
        GL11.glLineWidth((float)((float)(scale * (double)1.3f)));
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)xBegin, (double)yBegin);
        GL11.glVertex2d((double)xEnd, (double)yEnd);
        GL11.glEnd();
        double angle = Math.atan2(yEnd - yBegin, xEnd - xBegin) * 180.0 / Math.PI;
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)xEnd, (double)yEnd, (double)0.0);
        RenderSystem.rotatef((float)((float)angle), (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.scaled((double)scale, (double)scale, (double)1.0);
        GL11.glBegin((int)4);
        GL11.glVertex2d((double)3.0, (double)0.0);
        GL11.glVertex2d((double)0.0, (double)-1.5);
        GL11.glVertex2d((double)0.0, (double)1.5);
        GL11.glEnd();
        RenderSystem.popMatrix();
    }

    public static void drawLine(MatrixStack matrixStack, double xBegin, double yBegin, double xEnd, double yEnd, int color) {
        ColorHelper.setColor3f(color);
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)matrixStack.func_227866_c_().func_227870_a_());
        GL11.glLineWidth((float)((float)(RenderHelper.getGuiScaleFactor() * (double)1.3f)));
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)xBegin, (double)yBegin);
        GL11.glVertex2d((double)xEnd, (double)yEnd);
        GL11.glEnd();
        RenderSystem.popMatrix();
    }

    public static void drawPoint(double x, double y, int color) {
        ColorHelper.setColor3f(color);
        GL11.glPointSize((float)((float)(Minecraft.func_71410_x().func_228018_at_().func_198100_s() * (double)1.3f)));
        GL11.glBegin((int)0);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glEnd();
    }

    public static void renderEntity(MatrixStack matrixStack, int x, int y, double scale, double yaw, double pitch, LivingEntity livingEntity) {
        if (livingEntity.field_70170_p == null) {
            livingEntity.field_70170_p = Minecraft.func_71410_x().field_71441_e;
        }
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)matrixStack.func_227866_c_().func_227870_a_());
        RenderSystem.translatef((float)x, (float)y, (float)50.0f);
        RenderSystem.scalef((float)((float)(-scale)), (float)((float)scale), (float)((float)scale));
        MatrixStack mobMatrix = new MatrixStack();
        mobMatrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        IMobRenderHook.RenderInfo renderInfo = MobRegistryImpl.applyRenderHooks(livingEntity, new IMobRenderHook.RenderInfo(x, y, scale, yaw, pitch));
        x = renderInfo.x;
        y = renderInfo.y;
        scale = renderInfo.scale;
        yaw = renderInfo.yaw;
        pitch = renderInfo.pitch;
        RenderSystem.rotatef((float)((float)Math.atan(pitch / 40.0) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        livingEntity.field_70761_aq = (float)Math.atan(yaw / 40.0) * 20.0f;
        livingEntity.field_70177_z = (float)Math.atan(yaw / 40.0) * 40.0f;
        livingEntity.field_70125_A = -((float)Math.atan(pitch / 40.0)) * 20.0f;
        livingEntity.field_70759_as = livingEntity.field_70177_z;
        livingEntity.field_70758_at = livingEntity.field_70177_z;
        mobMatrix.func_227861_a_(0.0, livingEntity.func_70033_W(), 0.0);
        EntityRendererManager entityrenderermanager = Minecraft.func_71410_x().func_175598_ae();
        entityrenderermanager.func_178633_a(false);
        IRenderTypeBuffer.Impl renderTypeBuffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderSystem.runAsFancy(() -> entityrenderermanager.func_229084_a_((Entity)livingEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, mobMatrix, (IRenderTypeBuffer)renderTypeBuffer, 0xF000F0));
        renderTypeBuffer.func_228461_a_();
        entityrenderermanager.func_178633_a(true);
        RenderSystem.popMatrix();
    }

    public static void renderChest(MatrixStack matrixStack, float x, float y, float rotate, float scale, float lidAngle) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Resources.Vanilla.CHEST);
        matrixStack.func_227860_a_();
        RenderSystem.enableRescaleNormal();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.func_227861_a_((double)x, (double)y, 50.0);
        matrixStack.func_227863_a_(new Quaternion(-160.0f, 1.0f, 0.0f, 0.0f));
        matrixStack.func_227862_a_(scale, -scale, -scale);
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        matrixStack.func_227863_a_(new Quaternion(rotate, 0.0f, 1.0f, 0.0f));
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        float lidAngleF = lidAngle / 180.0f;
        lidAngleF = 1.0f - lidAngleF;
        lidAngleF = 1.0f - lidAngleF * lidAngleF * lidAngleF;
        RenderSystem.disableRescaleNormal();
        matrixStack.func_227865_b_();
    }

    public static void renderBlock(MatrixStack matrixStack, BlockState block, float x, float y, float z, float rotate, float scale) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderSystem.enableRescaleNormal();
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(new Quaternion(-30.0f, 0.0f, 1.0f, 0.0f));
        net.minecraft.client.renderer.RenderHelper.func_227783_c_();
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)x, (double)y, (double)(50.0f + z));
        matrixStack.func_227863_a_(new Quaternion(20.0f, 1.0f, 0.0f, 0.0f));
        matrixStack.func_227862_a_(scale *= 50.0f, -scale, -scale);
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        matrixStack.func_227863_a_(new Quaternion(rotate, 0.0f, 1.0f, 0.0f));
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        mc.func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
        mc.func_175602_ab().renderBlock(block, matrixStack, (IRenderTypeBuffer)IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c()), 0xF000F0, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
        matrixStack.func_227865_b_();
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        RenderSystem.disableRescaleNormal();
    }

    public static void scissor(MatrixStack matrixStack, int x, int y, int w, int h) {
        double scale = Minecraft.func_71410_x().func_228018_at_().func_198100_s();
        double[] xyzTranslation = RenderHelper.getGLTranslation(matrixStack, scale);
        x = (int)((double)x * scale);
        y = (int)((double)y * scale);
        w = (int)((double)w * scale);
        h = (int)((double)h * scale);
        int scissorX = Math.round(Math.round(xyzTranslation[0] + (double)x));
        int scissorY = Math.round(Math.round((double)(Minecraft.func_71410_x().func_228018_at_().func_198083_n() - y - h) - xyzTranslation[1]));
        int scissorW = Math.round(w);
        int scissorH = Math.round(h);
        IScissorHook.ScissorInfo scissorInfo = MobRegistryImpl.applyScissorHooks(new IScissorHook.ScissorInfo(scissorX, scissorY, scissorW, scissorH));
        GL11.glEnable((int)3089);
        GL11.glScissor((int)scissorInfo.x, (int)scissorInfo.y, (int)scissorInfo.width, (int)scissorInfo.height);
    }

    public static void stopScissor() {
        GL11.glDisable((int)3089);
    }

    public static void drawTexture(MatrixStack matrixStack, int x, int y, int u, int v, int width, int height, ResourceLocation resource) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resource);
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)matrixStack.func_227866_c_().func_227870_a_());
        GuiUtils.drawTexturedModalRect((int)x, (int)y, (int)u, (int)v, (int)width, (int)height, (float)0.0f);
        RenderSystem.popMatrix();
    }

    public static double[] getGLTranslation(MatrixStack matrixStack, double scale) {
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
        matrix.func_195879_b(buf);
        return new double[]{(double)buf.get(RenderHelper.getIndexFloatBuffer(0, 3)) * scale, (double)buf.get(RenderHelper.getIndexFloatBuffer(1, 3)) * scale, (double)buf.get(RenderHelper.getIndexFloatBuffer(2, 3)) * scale};
    }

    private static int getIndexFloatBuffer(int x, int y) {
        return y * 4 + x;
    }

    public static double getGuiScaleFactor() {
        return Minecraft.func_71410_x().func_228018_at_().func_198100_s();
    }
}

