/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.api.util;

import java.util.Random;
import mod.chiselsandbits.api.util.MathUtil;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class VectorUtils {
    public static final double DEG_TO_RAD_FACTOR = Math.PI / 180;

    private VectorUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: VectorUtils. This is a utility class");
    }

    public static Vector3d rotateMultipleTimes90Degrees(Vector3d vector3d, Direction.Axis axis, int times) {
        return VectorUtils.rotateDegrees(vector3d, axis, times * 90 % 360);
    }

    public static Vector3d rotate90Degrees(Vector3d vector3d, Direction.Axis axis) {
        return VectorUtils.rotateDegrees(vector3d, axis, 90.0);
    }

    public static Vector3d rotateHalfRadian(Vector3d vector3d, Direction.Axis axis) {
        return VectorUtils.rotate(vector3d, axis, 1.5707963267948966);
    }

    public static Vector3d rotateDegrees(Vector3d vector3d, Direction.Axis axis, double angleInDegrees) {
        return VectorUtils.rotate(vector3d, axis, angleInDegrees * (Math.PI / 180));
    }

    public static Vector3d rotate(Vector3d vector3d, Direction.Axis axis, double angleInRadian) {
        switch (axis) {
            case X: {
                return new Vector3d(vector3d.func_82615_a(), vector3d.func_82617_b() * Math.cos((float)angleInRadian) - vector3d.func_82616_c() * Math.sin((float)angleInRadian), vector3d.func_82617_b() * Math.sin((float)angleInRadian) + vector3d.func_82616_c() * Math.cos((float)angleInRadian));
            }
            case Y: {
                return new Vector3d(vector3d.func_82615_a() * Math.cos((float)angleInRadian) + vector3d.func_82616_c() * Math.sin((float)angleInRadian), vector3d.func_82617_b(), -vector3d.func_82615_a() * Math.sin((float)angleInRadian) + vector3d.func_82616_c() * Math.cos((float)angleInRadian));
            }
            case Z: {
                return new Vector3d(vector3d.func_82615_a() * Math.cos((float)angleInRadian) - vector3d.func_82617_b() * Math.sin((float)angleInRadian), vector3d.func_82615_a() * Math.sin((float)angleInRadian) + vector3d.func_82617_b() * Math.cos((float)angleInRadian), vector3d.func_82616_c());
            }
        }
        throw new IllegalArgumentException(String.format("Unknown axis: %s", axis));
    }

    public static Vector3d scaleToOne(Vector3d v) {
        double maxSize = Math.abs(VectorUtils.getMaximalComponent(v));
        if (MathUtil.almostEqual(maxSize, 0)) {
            return Vector3d.field_186680_a;
        }
        double scale = 1.0 / maxSize;
        return v.func_186678_a(scale);
    }

    public static double getMaximalComponent(Vector3d v) {
        double x = Math.abs(v.func_82615_a());
        double y = Math.abs(v.func_82617_b());
        double z = Math.abs(v.func_82616_c());
        if (x >= y && x >= z) {
            return v.func_82615_a();
        }
        if (y >= x && y >= z) {
            return v.func_82617_b();
        }
        if (z >= x && z >= y) {
            return v.func_82616_c();
        }
        return 0.0;
    }

    public static Vector3d invert(Vector3d v) {
        return v.func_216372_d(-1.0, -1.0, -1.0);
    }

    public static BlockPos invert(BlockPos v) {
        return new BlockPos(-1 * v.func_177958_n(), -1 * v.func_177956_o(), -1 * v.func_177952_p());
    }

    public static Vector3d minimizeTowardsZero(Vector3d start, Vector3d end) {
        return new Vector3d(MathUtil.minimizeTowardsZero(start.func_82615_a(), end.func_82615_a()), MathUtil.minimizeTowardsZero(start.func_82617_b(), end.func_82617_b()), MathUtil.minimizeTowardsZero(start.func_82616_c(), end.func_82616_c()));
    }

    public static Vector3d maximizeAwayFromZero(Vector3d start, Vector3d end) {
        return new Vector3d(MathUtil.maximizeAwayFromZero(start.func_82615_a(), end.func_82615_a()), MathUtil.maximizeAwayFromZero(start.func_82617_b(), end.func_82617_b()), MathUtil.maximizeAwayFromZero(start.func_82616_c(), end.func_82616_c()));
    }

    public static Vector3d absolute(Vector3d vector3d) {
        return new Vector3d(vector3d.func_82615_a() < 0.0 ? -1.0 * vector3d.func_82615_a() : vector3d.func_82615_a(), vector3d.func_82617_b() < 0.0 ? -1.0 * vector3d.func_82617_b() : vector3d.func_82617_b(), vector3d.func_82616_c() < 0.0 ? -1.0 * vector3d.func_82616_c() : vector3d.func_82616_c());
    }

    public static Vector3d offsetRandomly(Vector3d source, Random random, float radius) {
        return new Vector3d(source.field_72450_a + (double)((random.nextFloat() - 0.5f) * 2.0f * radius), source.field_72448_b + (double)((random.nextFloat() - 0.5f) * 2.0f * radius), source.field_72449_c + (double)((random.nextFloat() - 0.5f) * 2.0f * radius));
    }

    public static Vector3d minimize(Vector3d a, Vector3d b) {
        return new Vector3d(Math.min(a.func_82615_a(), b.func_82615_a()), Math.min(a.func_82617_b(), b.func_82617_b()), Math.min(a.func_82616_c(), b.func_82616_c()));
    }

    public static Vector3d maximize(Vector3d a, Vector3d b) {
        return new Vector3d(Math.max(a.func_82615_a(), b.func_82615_a()), Math.max(a.func_82617_b(), b.func_82617_b()), Math.max(a.func_82616_c(), b.func_82616_c()));
    }

    public static Vector3d makePositive(Vector3d inBlockOffset) {
        return new Vector3d(MathUtil.makePositive(inBlockOffset.func_82615_a()), MathUtil.makePositive(inBlockOffset.func_82617_b()), MathUtil.makePositive(inBlockOffset.func_82616_c()));
    }
}

