/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.change;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.IChiselsAndBitsAPI;
import mod.chiselsandbits.api.change.IChangeTracker;
import mod.chiselsandbits.api.change.changes.IChange;
import mod.chiselsandbits.api.change.changes.IllegalChangeAttempt;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.change.changes.BitChange;
import mod.chiselsandbits.change.changes.CombinedChange;
import mod.chiselsandbits.network.packets.ChangeTrackerUpdatedPacket;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;

public class ChangeTracker
implements IChangeTracker {
    protected final PlayerEntity player;
    protected final LinkedList<CombinedChange> changes = new LinkedList();
    protected int currentIndex = 0;

    public ChangeTracker() {
        this.player = null;
    }

    public ChangeTracker(PlayerEntity player) {
        this.player = player;
    }

    public void reset() {
        this.changes.clear();
        this.sendUpdate();
    }

    @Override
    public void onBlocksUpdated(Map<BlockPos, IMultiStateSnapshot> beforeStates, Map<BlockPos, IMultiStateSnapshot> afterState) {
        if (!beforeStates.keySet().containsAll(afterState.keySet()) || !afterState.keySet().containsAll(beforeStates.keySet())) {
            throw new IllegalArgumentException("Initial States and Target States reference difference block positions");
        }
        this.changes.addFirst(new CombinedChange(beforeStates.entrySet().stream().map(e -> new BitChange((BlockPos)e.getKey(), (IMultiStateSnapshot)e.getValue(), (IMultiStateSnapshot)afterState.get(e.getKey()))).collect(Collectors.toSet())));
        this.currentIndex = 0;
        int maxSize = (Integer)IChiselsAndBitsAPI.getInstance().getConfiguration().getServer().changeTrackerSize.get();
        if (this.changes.size() > maxSize) {
            while (this.changes.size() > maxSize) {
                this.changes.removeLast();
            }
        }
        this.sendUpdate();
    }

    @Override
    public Deque<IChange> getChanges() {
        return new LinkedList<IChange>(this.changes);
    }

    public Optional<IChange> getCurrentUndo() {
        if (this.getChanges().size() <= this.currentIndex || this.currentIndex < 0) {
            return Optional.empty();
        }
        return Optional.of(this.changes.get(this.currentIndex));
    }

    public Optional<IChange> getCurrentRedo() {
        if (this.getChanges().size() < this.currentIndex || this.currentIndex < 1) {
            return Optional.empty();
        }
        return Optional.of(this.changes.get(this.currentIndex - 1));
    }

    @Override
    public boolean canUndo(PlayerEntity player) {
        return this.getCurrentUndo().map(c -> c.canUndo(player)).orElse(false);
    }

    @Override
    public boolean canRedo(PlayerEntity player) {
        return this.getCurrentRedo().map(c -> c.canRedo(player)).orElse(false);
    }

    @Override
    public void undo(PlayerEntity player) throws IllegalChangeAttempt {
        if (!this.canUndo(player)) {
            throw new IllegalChangeAttempt();
        }
        if (this.getCurrentUndo().isPresent()) {
            IChange change = this.getCurrentUndo().get();
            change.undo(player);
            this.currentIndex = Math.min(this.changes.size(), this.currentIndex + 1);
            this.sendUpdate();
        }
    }

    @Override
    public void redo(PlayerEntity player) throws IllegalChangeAttempt {
        if (!this.canRedo(player)) {
            throw new IllegalChangeAttempt();
        }
        if (this.getCurrentRedo().isPresent()) {
            IChange change = this.getCurrentRedo().get();
            change.redo(player);
            this.currentIndex = Math.max(0, this.currentIndex - 1);
            this.sendUpdate();
        }
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("changes", (INBT)this.changes.stream().map(INBTSerializable::serializeNBT).collect(Collectors.toCollection(ListNBT::new)));
        tag.func_74768_a("index", this.currentIndex);
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.changes.clear();
        this.changes.addAll(nbt.func_150295_c("changes", 10).stream().map(CombinedChange::new).collect(Collectors.toList()));
        this.currentIndex = nbt.func_74762_e("index");
    }

    private void sendUpdate() {
        if (this.player != null && this.player instanceof ServerPlayerEntity) {
            ChiselsAndBits.getInstance().getNetworkChannel().sendToPlayer(new ChangeTrackerUpdatedPacket(this.serializeNBT()), (ServerPlayerEntity)this.player);
        }
    }
}

