/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.face;

import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;

public class FormatInfo {
    final int totalSize;
    final int faceSize;
    final int[] offsets;
    final int[] indexLengths;
    final int[] finalLengths;

    public FormatInfo(VertexFormat format) {
        int total = 0;
        this.indexLengths = new int[format.func_227894_c_().size()];
        this.finalLengths = new int[format.func_227894_c_().size()];
        this.offsets = new int[format.func_227894_c_().size()];
        for (int x = 0; x < this.indexLengths.length; ++x) {
            this.finalLengths[x] = ((VertexFormatElement)format.func_227894_c_().get(x)).getElementCount();
            this.indexLengths[x] = this.finalLengths[x];
            switch (((VertexFormatElement)format.func_227894_c_().get(x)).func_177375_c()) {
                default: {
                    this.indexLengths[x] = 0;
                    break;
                }
                case COLOR: {
                    this.indexLengths[x] = 4;
                    break;
                }
                case NORMAL: {
                    this.indexLengths[x] = 3;
                    break;
                }
                case POSITION: {
                    this.indexLengths[x] = 3;
                    break;
                }
                case UV: {
                    this.indexLengths[x] = 2;
                }
            }
            this.offsets[x] = total;
            total += this.indexLengths[x];
        }
        this.totalSize = total;
        this.faceSize = total * 4;
    }

    public int[] pack(float[][][] unpackedData) {
        int[] out = new int[this.faceSize];
        int offset = 0;
        for (int f = 0; f < 4; ++f) {
            float[][] run2 = unpackedData[f];
            for (int x = 0; x < this.indexLengths.length; ++x) {
                float[] run = run2[x];
                for (int z = 0; z < this.indexLengths[x]; ++z) {
                    out[offset++] = run.length > z ? Float.floatToRawIntBits(run[z]) : 0;
                }
            }
        }
        return out;
    }

    public float[] unpack(int[] raw, int vertex, int index) {
        int size = this.indexLengths[index];
        float[] out = new float[size];
        int start = vertex * this.totalSize + this.offsets[index];
        for (int x = 0; x < size; ++x) {
            out[x] = Float.intBitsToFloat(raw[start + x]);
        }
        return out;
    }
}

