/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item;

import java.util.List;
import mod.chiselsandbits.api.config.Configuration;
import mod.chiselsandbits.api.item.tool.IQuillItem;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.api.util.VectorUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuillItem
extends Item
implements IQuillItem {
    private final String CONST_INTERACTION = "Interaction";
    private final String CONST_SIMULATION = "Simulation";

    public QuillItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean isInteracting(ItemStack stack) {
        return stack.func_77973_b() == this && stack.func_196082_o().func_74764_b("Interaction");
    }

    @Override
    public ItemStack getInteractionTarget(ItemStack stack) {
        return this.isInteracting(stack) ? ItemStack.func_199557_a((CompoundNBT)stack.func_190925_c("Interaction")) : ItemStack.field_190927_a;
    }

    @Override
    public boolean isRunningASimulatedInteraction(ItemStack stack) {
        return this.isInteracting(stack) && stack.func_196082_o().func_74764_b("Simulation");
    }

    @Override
    public float getBobbingTickCount() {
        return 4.0f;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public int getItemEnchantability(ItemStack stack) {
        return 5;
    }

    public int func_77626_a(@NotNull ItemStack stack) {
        return 32;
    }

    public int func_77619_b() {
        return 5;
    }

    public static void spawnParticles(Vector3d location, ItemStack polishedStack, World world) {
        for (int i = 0; i < 20; ++i) {
            Vector3d motion = VectorUtils.offsetRandomly(Vector3d.field_186680_a, world.field_73012_v, 0.125f);
            world.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, polishedStack), location.field_72450_a, location.field_72448_b, location.field_72449_c, motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
        }
    }

    public void func_77615_a(@NotNull ItemStack stack, @NotNull World worldIn, @NotNull LivingEntity entityLiving, int timeLeft) {
        if (!(entityLiving instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityLiving;
        if (this.isInteracting(stack)) {
            ItemStack interactionTarget = this.getInteractionTarget(stack);
            player.field_71071_by.func_191975_a(worldIn, interactionTarget);
            stack.func_196082_o().func_82580_o("Interaction");
        }
    }

    @NotNull
    public ItemStack func_77654_b(@NotNull ItemStack stack, @NotNull World worldIn, @NotNull LivingEntity entityLiving) {
        if (!(entityLiving instanceof PlayerEntity)) {
            return stack;
        }
        PlayerEntity player = (PlayerEntity)entityLiving;
        if (this.isInteracting(stack)) {
            ItemStack target = this.getInteractionTarget(stack);
            ItemStack pattern = QuillItem.createPattern(player);
            if (worldIn.field_72995_K) {
                QuillItem.spawnParticles(entityLiving.func_174824_e(1.0f).func_178787_e(entityLiving.func_70040_Z().func_186678_a(0.5)), target, worldIn);
                return stack;
            }
            if (!pattern.func_190926_b()) {
                if (player instanceof FakePlayer) {
                    player.func_146097_a(pattern, false, false);
                } else {
                    player.field_71071_by.func_191975_a(worldIn, pattern);
                }
            }
            stack.func_196082_o().func_82580_o("Interaction");
            stack.func_222118_a(1, entityLiving, p -> p.func_213334_d(p.func_184600_cs()));
        }
        return stack;
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World worldIn, PlayerEntity playerIn, @NotNull Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        ActionResult FAIL = new ActionResult(ActionResultType.FAIL, (Object)itemstack);
        if (this.isInteracting(itemstack)) {
            playerIn.func_184598_c(handIn);
            return new ActionResult(ActionResultType.PASS, (Object)itemstack);
        }
        Hand otherHand = handIn == Hand.MAIN_HAND ? Hand.OFF_HAND : Hand.MAIN_HAND;
        ItemStack itemInOtherHand = playerIn.func_184586_b(otherHand);
        if (QuillItem.createPattern(playerIn).func_77973_b() != Items.field_151121_aF && itemInOtherHand.func_77973_b() == Items.field_151121_aF) {
            ItemStack item = itemInOtherHand.func_77946_l();
            ItemStack target = item.func_77979_a(1);
            playerIn.func_184598_c(handIn);
            itemstack.func_196082_o().func_218657_a("Interaction", (INBT)target.serializeNBT());
            playerIn.func_184611_a(otherHand, item);
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    private static ItemStack createPattern(PlayerEntity playerEntity) {
        RayTraceResult rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK || !(rayTraceResult instanceof BlockRayTraceResult)) {
            return new ItemStack((IItemProvider)Items.field_151121_aF);
        }
        BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
        IWorldAreaMutator areaMutator = IMutatorFactory.getInstance().in((IWorld)playerEntity.func_130014_f_(), blockRayTraceResult.func_216350_a());
        return areaMutator.createSnapshot().toItemStack().toPatternStack();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        Configuration.getInstance().getCommon().helpText(LocalStrings.HelpQuill, tooltip, new Object[0]);
    }
}

