/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.legacy.serialization.blob;

import java.util.List;
import mod.chiselsandbits.api.block.state.id.IBlockStateIdManager;
import mod.chiselsandbits.legacy.serialization.blob.BlobSerializer;
import mod.chiselsandbits.utils.PaletteUtils;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.palette.ArrayPalette;
import net.minecraft.util.palette.HashMapPalette;
import net.minecraft.util.palette.IPalette;
import net.minecraft.util.palette.IResizeCallback;
import net.minecraft.util.palette.IdentityPalette;
import net.minecraftforge.registries.GameData;

public class PalettedBlobSerializer
extends BlobSerializer
implements IResizeCallback<BlockState> {
    private final ObjectIntIdentityMap<BlockState> registry = GameData.getBlockStateIDMap();
    private final IPalette<BlockState> registryPalette = new IdentityPalette(GameData.getBlockStateIDMap(), (Object)Blocks.field_150350_a.func_176223_P());
    private IPalette<BlockState> palette = new IdentityPalette(GameData.getBlockStateIDMap(), (Object)Blocks.field_150350_a.func_176223_P());
    private int bits = 0;

    public PalettedBlobSerializer(PacketBuffer toInflate) {
        this.setBits(4);
        this.setBits(toInflate.func_150792_a());
        PaletteUtils.read(this.palette, toInflate);
    }

    private void setBits(int bitsIn) {
        this.setBits(bitsIn, false);
    }

    private void setBits(int bitsIn, boolean forceBits) {
        if (bitsIn != this.bits) {
            this.bitsPerInt = bitsIn;
            this.bitsPerIntMinus1 = bitsIn - 1;
            this.bits = bitsIn;
            if (this.bits <= 8) {
                this.bits = 4;
                this.palette = new ArrayPalette(this.registry, this.bits, (IResizeCallback)this, NBTUtil::func_190008_d);
            } else if (this.bits < 17) {
                this.palette = new HashMapPalette(this.registry, this.bits, (IResizeCallback)this, NBTUtil::func_190008_d, NBTUtil::func_190009_a);
            } else {
                this.palette = this.registryPalette;
                this.bits = MathHelper.func_151241_e((int)this.registry.func_186804_a());
                if (forceBits) {
                    this.bits = bitsIn;
                }
            }
            this.palette.func_186041_a((Object)Blocks.field_150350_a.func_176223_P());
        }
    }

    @Override
    public void write(PacketBuffer to) {
        to.func_150787_b(this.bits);
        this.palette.func_186037_b(to);
    }

    @Override
    protected int readStateID(PacketBuffer buffer) {
        return 0;
    }

    @Override
    protected void writeStateID(PacketBuffer buffer, int key) {
    }

    @Override
    protected int getIndex(int stateID) {
        return this.palette.func_186041_a((Object)IBlockStateIdManager.getInstance().getBlockStateFrom(stateID));
    }

    @Override
    protected int getStateID(int indexID) {
        return IBlockStateIdManager.getInstance().getIdFrom((BlockState)this.palette.func_186039_a(indexID));
    }

    @Override
    public int getVersion() {
        return 3;
    }

    public int onResize(int newBitSize, BlockState violatingBlockState) {
        IPalette<BlockState> currentPalette = this.palette;
        this.setBits(newBitSize);
        List<BlockState> ids = PaletteUtils.getOrderedListInPalette(currentPalette);
        ids.forEach(arg_0 -> this.palette.func_186041_a(arg_0));
        return this.palette.func_186041_a((Object)violatingBlockState);
    }
}

