/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.config;

import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedBooleanValue;
import mekanism.common.config.value.CachedIntValue;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class AdditionsConfig
extends BaseMekanismConfig {
    private final ForgeConfigSpec configSpec;
    public final CachedIntValue obsidianTNTDelay;
    public final CachedIntValue obsidianTNTBlastRadius;
    public final CachedBooleanValue voiceServerEnabled;
    public final CachedIntValue voicePort;

    AdditionsConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Mekanism Additions Config. This config is synced between server and client.").push("additions");
        this.obsidianTNTDelay = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Fuse time for Obsidian TNT.").defineInRange("obsidianTNTDelay", 100, 0, Integer.MAX_VALUE));
        this.obsidianTNTBlastRadius = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Radius of the explosion of Obsidian TNT.").define("obsidianTNTBlastRadius", (Object)12));
        this.voiceServerEnabled = CachedBooleanValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("Enables the voice server for Walkie Talkies.").define("voiceServerEnabled", false));
        this.voicePort = CachedIntValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("TCP port for the Voice server to listen on.").defineInRange("VoicePort", 36123, 1, 65535));
        builder.pop();
        this.configSpec = builder.build();
    }

    public String getFileName() {
        return "additions";
    }

    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }
}

