/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.entity;

import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import mekanism.additions.common.config.AdditionsCommonConfig;
import mekanism.additions.common.config.MekanismAdditionsConfig;
import mekanism.additions.common.entity.baby.EntityBabyStray;
import mekanism.additions.common.item.AdditionsSpawnEggItem;
import mekanism.additions.common.registries.AdditionsEntityTypes;
import mekanism.additions.common.registries.AdditionsItems;
import mekanism.common.Mekanism;
import mekanism.common.registration.impl.EntityTypeRegistryObject;
import mekanism.common.registration.impl.ItemRegistryObject;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.StructureSpawnListGatherEvent;

public class SpawnHelper {
    private SpawnHelper() {
    }

    public static void setupEntities() {
        SpawnHelper.registerSpawnControls(AdditionsEntityTypes.BABY_CREEPER, AdditionsEntityTypes.BABY_ENDERMAN, AdditionsEntityTypes.BABY_SKELETON, AdditionsEntityTypes.BABY_WITHER_SKELETON);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)AdditionsEntityTypes.BABY_STRAY.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityBabyStray::spawnRestrictions);
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)AdditionsEntityTypes.BABY_CREEPER.get()), (AttributeModifierMap)CreeperEntity.func_234278_m_().func_233813_a_());
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)AdditionsEntityTypes.BABY_ENDERMAN.get()), (AttributeModifierMap)EndermanEntity.func_234287_m_().func_233813_a_());
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)AdditionsEntityTypes.BABY_SKELETON.get()), (AttributeModifierMap)AbstractSkeletonEntity.func_234275_m_().func_233813_a_());
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)AdditionsEntityTypes.BABY_STRAY.get()), (AttributeModifierMap)AbstractSkeletonEntity.func_234275_m_().func_233813_a_());
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)AdditionsEntityTypes.BABY_WITHER_SKELETON.get()), (AttributeModifierMap)AbstractSkeletonEntity.func_234275_m_().func_233813_a_());
        SpawnHelper.registerDelayedDispenserBehavior(AdditionsItems.BABY_CREEPER_SPAWN_EGG, AdditionsItems.BABY_ENDERMAN_SPAWN_EGG, AdditionsItems.BABY_SKELETON_SPAWN_EGG, AdditionsItems.BABY_STRAY_SPAWN_EGG, AdditionsItems.BABY_WITHER_SKELETON_SPAWN_EGG);
        ParrotEntity.field_192017_bK.put(AdditionsEntityTypes.BABY_CREEPER.get(), SoundEvents.field_193792_eN);
        ParrotEntity.field_192017_bK.put(AdditionsEntityTypes.BABY_SKELETON.get(), SoundEvents.field_193811_fa);
        ParrotEntity.field_192017_bK.put(AdditionsEntityTypes.BABY_STRAY.get(), SoundEvents.field_193814_fd);
        ParrotEntity.field_192017_bK.put(AdditionsEntityTypes.BABY_WITHER_SKELETON.get(), SoundEvents.field_193819_fi);
    }

    @SafeVarargs
    private static void registerSpawnControls(EntityTypeRegistryObject<? extends MonsterEntity> ... entityTypeROs) {
        for (EntityTypeRegistryObject<? extends MonsterEntity> entityTypeRO : entityTypeROs) {
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)entityTypeRO.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        }
    }

    @SafeVarargs
    private static void registerDelayedDispenserBehavior(ItemRegistryObject<AdditionsSpawnEggItem> ... spawnEggs) {
        DefaultDispenseItemBehavior dispenseBehavior = new DefaultDispenseItemBehavior(){

            @Nonnull
            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                Direction direction = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
                EntityType entityType = ((SpawnEggItem)stack.func_77973_b()).func_208076_b(stack.func_77978_p());
                entityType.func_220331_a(source.func_197524_h(), stack, null, source.func_180699_d().func_177972_a(direction), SpawnReason.DISPENSER, direction != Direction.UP, false);
                stack.func_190918_g(1);
                return stack;
            }
        };
        for (ItemRegistryObject<AdditionsSpawnEggItem> spawnEgg : spawnEggs) {
            DispenserBlock.func_199774_a(spawnEgg, (IDispenseItemBehavior)dispenseBehavior);
        }
    }

    private static MobSpawnInfo.Spawners getSpawner(AdditionsCommonConfig.SpawnConfig spawnConfig, MobSpawnInfo.Spawners parentEntry) {
        int weight = (int)Math.ceil((double)parentEntry.field_76292_a * spawnConfig.weightPercentage.get());
        int minSize = (int)Math.ceil((double)parentEntry.field_242589_d * spawnConfig.minSizePercentage.get());
        int maxSize = (int)Math.ceil((double)parentEntry.field_242590_e * spawnConfig.maxSizePercentage.get());
        return new MobSpawnInfo.Spawners(spawnConfig.entityTypeProvider.getEntityType(), weight, minSize, Math.max(minSize, maxSize));
    }

    private static Stream<AdditionsCommonConfig.SpawnConfig> getSpawnConfigs() {
        return Stream.of(MekanismAdditionsConfig.common.babyCreeper, MekanismAdditionsConfig.common.babyEnderman, MekanismAdditionsConfig.common.babySkeleton, MekanismAdditionsConfig.common.babyStray, MekanismAdditionsConfig.common.babyWitherSkeleton);
    }

    public static void onBiomeLoad(BiomeLoadingEvent event) {
        MobSpawnInfoBuilder spawns = event.getSpawns();
        List monsterSpawns = spawns.getSpawner(EntityClassification.MONSTER);
        if (!monsterSpawns.isEmpty()) {
            ResourceLocation biomeName = event.getName();
            SpawnHelper.getSpawnConfigs().filter(spawnConfig -> spawnConfig.shouldSpawn.get() && !((List)spawnConfig.biomeBlackList.get()).contains(biomeName)).forEach(spawnConfig -> {
                EntityType parent = spawnConfig.parentTypeProvider.getEntityType();
                monsterSpawns.stream().filter(monsterSpawn -> monsterSpawn.field_242588_c == parent).findFirst().ifPresent(parentEntry -> {
                    MobSpawnInfo.Spawners spawner = SpawnHelper.getSpawner(spawnConfig, parentEntry);
                    spawns.func_242575_a(EntityClassification.MONSTER, spawner);
                    MobSpawnInfo.SpawnCosts parentCost = spawns.getCost(parent);
                    if (parentCost == null) {
                        Mekanism.logger.debug("Adding spawn rate for '{}' in biome '{}', with weight: {}, minSize: {}, maxSize: {}", (Object)spawner.field_242588_c.getRegistryName(), (Object)biomeName, (Object)spawner.field_76292_a, (Object)spawner.field_242589_d, (Object)spawner.field_242590_e);
                    } else {
                        double spawnCostPerEntity = parentCost.func_242585_b() * spawnConfig.spawnCostPerEntityPercentage.get();
                        double maxSpawnCost = parentCost.func_242582_a() * spawnConfig.maxSpawnCostPercentage.get();
                        spawns.func_242573_a(spawner.field_242588_c, spawnCostPerEntity, maxSpawnCost);
                        Mekanism.logger.debug("Adding spawn rate for '{}' in biome '{}', with weight: {}, minSize: {}, maxSize: {}, spawnCostPerEntity: {}, maxSpawnCost: {}", (Object)spawner.field_242588_c.getRegistryName(), (Object)biomeName, (Object)spawner.field_76292_a, (Object)spawner.field_242589_d, (Object)spawner.field_242590_e, (Object)spawnCostPerEntity, (Object)maxSpawnCost);
                    }
                });
            });
        }
    }

    public static void onStructureSpawnListGather(StructureSpawnListGatherEvent event) {
        List monsterSpawns = event.getEntitySpawns(EntityClassification.MONSTER);
        if (!monsterSpawns.isEmpty()) {
            ResourceLocation structureName = event.getStructure().getRegistryName();
            SpawnHelper.getSpawnConfigs().filter(spawnConfig -> spawnConfig.shouldSpawn.get() && !((List)spawnConfig.structureBlackList.get()).contains(structureName)).forEach(spawnConfig -> {
                EntityType parent = spawnConfig.parentTypeProvider.getEntityType();
                monsterSpawns.stream().filter(monsterSpawn -> monsterSpawn.field_242588_c == parent).findFirst().ifPresent(parentEntry -> {
                    MobSpawnInfo.Spawners spawner = SpawnHelper.getSpawner(spawnConfig, parentEntry);
                    event.addEntitySpawn(EntityClassification.MONSTER, spawner);
                    Mekanism.logger.debug("Adding spawn rate for '{}' in structure '{}', with weight: {}, minSize: {}, maxSize: {}", (Object)spawner.field_242588_c.getRegistryName(), (Object)structureName, (Object)spawner.field_76292_a, (Object)spawner.field_242589_d, (Object)spawner.field_242590_e);
                });
            });
        }
    }
}

