/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.additions.common.AdditionsLang;
import mekanism.additions.common.config.MekanismAdditionsConfig;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemWalkieTalkie
extends Item
implements IModeItem {
    public ItemWalkieTalkie(Item.Properties properties) {
        super(properties.func_200917_a(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        tooltip.add(BooleanStateDisplay.OnOff.of((boolean)this.getOn(stack), (boolean)true).getTextComponent());
        tooltip.add((ITextComponent)AdditionsLang.CHANNEL.translateColored(EnumColor.DARK_AQUA, new Object[]{EnumColor.GRAY, this.getChannel(stack)}));
        if (!MekanismAdditionsConfig.additions.voiceServerEnabled.get()) {
            tooltip.add((ITextComponent)AdditionsLang.WALKIE_DISABLED.translateColored(EnumColor.DARK_RED, new Object[0]));
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            this.setOn(itemStack, !this.getOn(itemStack));
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemStack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)itemStack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }

    public void setOn(ItemStack itemStack, boolean on) {
        ItemDataUtils.setBoolean((ItemStack)itemStack, (String)"running", (boolean)on);
    }

    public boolean getOn(ItemStack itemStack) {
        return ItemDataUtils.getBoolean((ItemStack)itemStack, (String)"running");
    }

    public void setChannel(ItemStack itemStack, int channel) {
        ItemDataUtils.setInt((ItemStack)itemStack, (String)"channel", (int)channel);
    }

    public int getChannel(ItemStack itemStack) {
        int channel = ItemDataUtils.getInt((ItemStack)itemStack, (String)"channel");
        if (channel == 0) {
            this.setChannel(itemStack, 1);
            channel = 1;
        }
        return channel;
    }

    public void changeMode(@Nonnull PlayerEntity player, @Nonnull ItemStack stack, int shift, boolean displayChangeMessage) {
        int newChannel;
        int channel;
        if (this.getOn(stack) && (channel = this.getChannel(stack)) != (newChannel = Math.floorMod(channel + shift - 1, 8) + 1)) {
            this.setChannel(stack, newChannel);
            if (displayChangeMessage) {
                player.func_145747_a((ITextComponent)MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, new Object[]{MekanismLang.MEKANISM, EnumColor.GRAY, AdditionsLang.CHANNEL_CHANGE.translate(new Object[]{newChannel})}), Util.field_240973_b_);
            }
        }
    }

    @Nonnull
    public ITextComponent getScrollTextComponent(@Nonnull ItemStack stack) {
        return AdditionsLang.CHANNEL.translateColored(EnumColor.GRAY, new Object[]{this.getChannel(stack)});
    }
}

