/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila;

import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.addons.core.PluginCore;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.WailaPlugin;
import mcp.mobius.waila.api.impl.WailaRegistrar;
import mcp.mobius.waila.api.impl.config.PluginConfig;
import mcp.mobius.waila.api.impl.config.WailaConfig;
import mcp.mobius.waila.command.CommandDumpHandlers;
import mcp.mobius.waila.network.MessageReceiveData;
import mcp.mobius.waila.network.MessageRequestEntity;
import mcp.mobius.waila.network.MessageRequestTile;
import mcp.mobius.waila.network.MessageServerPing;
import mcp.mobius.waila.utils.JsonConfig;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="waila")
public class Waila {
    public static final String MODID = "waila";
    public static final String NAME = "Waila";
    public static final Logger LOGGER = LogManager.getLogger((String)"Waila");
    public static final SimpleChannel NETWORK = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("waila", "networking")).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> "1.0.0").simpleChannel();
    public static final JsonConfig<WailaConfig> CONFIG = new JsonConfig<WailaConfig>("waila/waila", WailaConfig.class).withGson(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(WailaConfig.ConfigOverlay.ConfigOverlayColor.class, (Object)new WailaConfig.ConfigOverlay.ConfigOverlayColor.Adapter()).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).create());

    public Waila() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupClient);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        MinecraftForge.EVENT_BUS.addListener(this::playerJoin);
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
        NETWORK.registerMessage(0, MessageReceiveData.class, MessageReceiveData::write, MessageReceiveData::read, MessageReceiveData.Handler::onMessage);
        NETWORK.registerMessage(1, MessageServerPing.class, MessageServerPing::write, MessageServerPing::read, MessageServerPing.Handler::onMessage);
        NETWORK.registerMessage(2, MessageRequestEntity.class, MessageRequestEntity::write, MessageRequestEntity::read, MessageRequestEntity.Handler::onMessage);
        NETWORK.registerMessage(3, MessageRequestTile.class, MessageRequestTile::write, MessageRequestTile::read, MessageRequestTile.Handler::onMessage);
    }

    @SubscribeEvent
    public void setupClient(FMLClientSetupEvent event) {
        WailaClient.initClient();
    }

    @SubscribeEvent
    public void loadComplete(FMLLoadCompleteEvent event) {
        new PluginCore().register(WailaRegistrar.INSTANCE);
        ModList.get().getAllScanData().forEach(scan -> scan.getAnnotations().forEach(a -> {
            String required;
            if (a.getAnnotationType().getClassName().equals(WailaPlugin.class.getName()) && ((required = a.getAnnotationData().getOrDefault("value", "")).isEmpty() || ModList.get().isLoaded(required))) {
                try {
                    Class<?> clazz = Class.forName(a.getMemberName());
                    if (IWailaPlugin.class.isAssignableFrom(clazz)) {
                        IWailaPlugin plugin = (IWailaPlugin)clazz.newInstance();
                        plugin.register(WailaRegistrar.INSTANCE);
                        LOGGER.info("Registered plugin at {}", (Object)a.getMemberName());
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error loading plugin at {}", (Object)a.getMemberName(), (Object)e);
                }
            }
        }));
        PluginConfig.INSTANCE.reload();
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        CommandDumpHandlers.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        LOGGER.info("Syncing config to {} ({})", (Object)event.getPlayer().func_146103_bH().getName(), (Object)event.getPlayer().func_146103_bH().getId());
        NETWORK.sendTo((Object)new MessageServerPing(PluginConfig.INSTANCE), ((ServerPlayerEntity)event.getPlayer()).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }
}

